"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.verify = exports.hash = void 0;
const argon = require("argon2");
const hash = async (password) => {
    try {
        return await argon.hash(password);
    }
    catch (err) {
        return '0';
    }
};
exports.hash = hash;
const verify = async (hashed, password) => {
    try {
        return await argon.verify(hashed, password);
    }
    catch (err) {
        return false;
    }
};
exports.verify = verify;
//# sourceMappingURL=password.js.map