"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AxiosService = void 0;
const common_1 = require("@nestjs/common");
const axios_1 = require("axios");
const object_case_converter_1 = require("@ridi/object-case-converter");
let AxiosService = class AxiosService {
    constructor() {
        this._khaneavalOldServer = axios_1.default.create({
            baseURL: 'https://server.khanehaval.com',
        });
        this._neshan = axios_1.default.create({
            baseURL: 'https://api.neshan.org/',
        });
        this._khaneavalOldServer.interceptors.request.use(async (config) => {
            config.headers = {
                'Content-Type': 'application/json; charset=utf-8',
                Accept: 'application/json',
                Authorization: `CsLnBuDBG1CpZqsLUMHVc17hK5VjLLj1`,
            };
            return config;
        });
        this._neshan.interceptors.request.use(async (config) => {
            config.headers = {
                'Api-Key': `service.3395c2a9b0004e10a70f277b5efec4c3`,
            };
            return config;
        });
        this._khaneavalOldServer.interceptors.response.use((res) => {
            const data = res.data;
            return (0, object_case_converter_1.camelize)(data, { recursive: true });
        });
        this._neshan.interceptors.response.use((res) => {
            const { status, location } = res.data;
            return location || {};
        });
    }
    get oldServer() {
        return this._khaneavalOldServer;
    }
    get neshan() {
        return this._neshan;
    }
};
exports.AxiosService = AxiosService;
exports.AxiosService = AxiosService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], AxiosService);
//# sourceMappingURL=axios.js.map