"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JwtAuthGuard = void 0;
const passport_1 = require("@nestjs/passport");
const common_1 = require("@nestjs/common");
const dict_1 = require("../../constants/dict");
class JwtAuthGuard extends (0, passport_1.AuthGuard)('jwt') {
    constructor() {
        super();
    }
    handleRequest(err, user, info, context) {
        if (!user) {
            throw new common_1.UnauthorizedException(dict_1.default.NOT_AUTHENTICATED);
        }
        return user;
    }
}
exports.JwtAuthGuard = JwtAuthGuard;
//# sourceMappingURL=jwt-guard.js.map