"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateDatabase = exports.options = void 0;
const typeorm_1 = require("typeorm");
const typeorm_extension_1 = require("typeorm-extension");
const person_entity_1 = require("./entities/user/person.entity");
const agency_entity_1 = require("./entities/user/agency.entity");
const consultant_entity_1 = require("./entities/user/consultant.entity");
const message_entity_1 = require("./entities/user/message.entity");
const place_entity_1 = require("./entities/place.entity");
const place_info_entity_1 = require("./entities/place-info.entity");
const admin_seeder_1 = require("./seeders/admin.seeder");
const place_seeder_1 = require("./seeders/place.seeder");
const dotenv_1 = require("dotenv");
const ads_params_1 = require("./entities/ads-params");
const advertise_entity_1 = require("./entities/advertise.entity");
const user_entity_1 = require("./entities/user.entity");
const age_seeder_1 = require("./seeders/age.seeder");
const ads_types_1 = require("./entities/ads-types");
(0, dotenv_1.config)();
const { port = 3306, host = "localhost", username = "khaneha2_users", password = "!@#7111375!@#", database = "nest_khaneh_db" } = process.env;
const entities = [
    user_entity_1.UserEntity,
    person_entity_1.PersonEntity,
    agency_entity_1.AgencyEntity,
    consultant_entity_1.ConsultantEntity,
    message_entity_1.MessageEntity,
    place_entity_1.PlaceEntity,
    place_info_entity_1.PlaceInfoEntity,
    advertise_entity_1.Advertise,
    ...ads_types_1.Ads,
    ...ads_params_1.AdsParams,
];
exports.options = {
    type: 'mysql',
    host,
    port: Number(port),
    username,
    password,
    database,
    synchronize: true,
    logging: true,
    charset: 'UTF8_GENERAL_CI',
    entities,
    migrations: [],
    subscribers: [],
    migrationsRun: true,
    seeds: [admin_seeder_1.AdminSeeder, place_seeder_1.PlaceSeeder, age_seeder_1.AgeSeeder],
};
const CreateDatabase = async () => await (0, typeorm_extension_1.createDatabase)({ options: exports.options, ifNotExist: true });
exports.CreateDatabase = CreateDatabase;
exports.default = new typeorm_1.DataSource(exports.options);
//# sourceMappingURL=ds.js.map