import { Age, IAge } from "../ads-params/age.entity";
import { BuildingSide, IBuildingSide } from "../ads-params/builing-side.entity";
import { CabinetType, ICabinetType } from "../ads-params/cabinet.entity";
import { IReconstructionType, ReconstructionType } from "../ads-params/construction.entity";
import { CoolingSystemType, ICoolSystemType } from "../ads-params/cool-system-type.entity";
import { FloorNubmer } from "../ads-params/floor-number.entity";
import { FlooringMaterialType, IFlooringMaterialType } from "../ads-params/flooring-material-type.entity";
import { HeatingSystemType, IHeatingSystemType } from "../ads-params/heat-system-type.entity";
import { HeatWaterSystemType, IHeatWaterSystem } from "../ads-params/heat-water-system.entity";
import { IRoom, Room } from "../ads-params/room.entity";
import { TotalFloorType } from "../ads-params/total-floor-type.entity";
import { IUnitInEachFloor, UnitInEachFloor } from "../ads-params/unit-in-each-floor.enity";
import { IWC, Wc } from "../ads-params/wc.entity";
import { Advertise, IAdvertise } from "../advertise.entity";
export declare class RentApartment extends Advertise implements IRentApartment {
    constructor(props?: IRentApartment);
    afterLoad(): void;
    updateProps(): void;
    mortgageAmount?: number;
    rentAmount?: number;
    hasAbilityToChange?: boolean;
    meterage?: number;
    buildingType?: 'penthouse' | 'tower' | 'suite';
    age?: Age;
    room?: Room;
    floorNumber?: FloorNubmer;
    hasGarage?: boolean;
    hasElevator?: boolean;
    hasStoreHouse?: boolean;
    totalFloors?: TotalFloorType;
    unitInFloor?: UnitInEachFloor;
    totalUnits?: number;
    buildingSide?: BuildingSide;
    reconstruct?: ReconstructionType;
    flooringMaterialType?: FlooringMaterialType;
    cabinetType?: CabinetType;
    wc?: Wc;
    coolingSystemType?: CoolingSystemType;
    heatingSystemType?: HeatingSystemType;
    heatWaterSystemType?: HeatWaterSystemType;
    hasCentralAnthena?: boolean;
    hasConferenceHall?: boolean;
    hasBathTub?: boolean;
    hasMasterRoom?: boolean;
    hasBalcony?: boolean;
    hasGazebo?: boolean;
    hasSwimmingPool?: boolean;
    hasRoofGarden?: boolean;
    hasLobby?: boolean;
    hasGamingRoom?: boolean;
    hasSportingHall?: boolean;
    hasSaunaJacuzzi?: boolean;
}
export interface IRentApartment extends IAdvertise {
    mortgageAmount?: number;
    rentAmount?: number;
    hasAbilityToChange?: boolean;
    meterage?: number;
    buildingType?: 'penthouse' | 'tower' | 'suite';
    age?: IAge;
    room?: IRoom;
    floorNumber?: FloorNubmer;
    hasGarage?: boolean;
    hasElevator?: boolean;
    hasStoreHouse?: boolean;
    totalFloors?: TotalFloorType;
    unitInFloor?: IUnitInEachFloor;
    totalUnits?: number;
    buildingSide?: IBuildingSide;
    reconstruct?: IReconstructionType;
    flooringMaterialType?: IFlooringMaterialType;
    cabinetType?: ICabinetType;
    wc?: IWC;
    coolingSystemType?: ICoolSystemType;
    heatingSystemType?: IHeatingSystemType;
    heatWaterSystemType?: IHeatWaterSystem;
    hasCentralAnthena?: boolean;
    hasConferenceHall?: boolean;
    hasBathTub?: boolean;
    hasMasterRoom?: boolean;
    hasBalcony?: boolean;
    hasGazebo?: boolean;
    hasSwimmingPool?: boolean;
    hasRoofGarden?: boolean;
    hasLobby?: boolean;
    hasGamingRoom?: boolean;
    hasSportingHall?: boolean;
}
