"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RentApartment = void 0;
const typeorm_1 = require("typeorm");
const age_entity_1 = require("../ads-params/age.entity");
const builing_side_entity_1 = require("../ads-params/builing-side.entity");
const cabinet_entity_1 = require("../ads-params/cabinet.entity");
const construction_entity_1 = require("../ads-params/construction.entity");
const cool_system_type_entity_1 = require("../ads-params/cool-system-type.entity");
const floor_number_entity_1 = require("../ads-params/floor-number.entity");
const flooring_material_type_entity_1 = require("../ads-params/flooring-material-type.entity");
const heat_system_type_entity_1 = require("../ads-params/heat-system-type.entity");
const heat_water_system_entity_1 = require("../ads-params/heat-water-system.entity");
const room_entity_1 = require("../ads-params/room.entity");
const total_floor_type_entity_1 = require("../ads-params/total-floor-type.entity");
const unit_in_each_floor_enity_1 = require("../ads-params/unit-in-each-floor.enity");
const wc_entity_1 = require("../ads-params/wc.entity");
const advertise_entity_1 = require("../advertise.entity");
const class_validator_1 = require("class-validator");
const swagger_1 = require("@nestjs/swagger");
let RentApartment = class RentApartment extends advertise_entity_1.Advertise {
    constructor(props) {
        super(props);
    }
    afterLoad() {
        this.mortgageAmount = Number(this.mortgageAmount);
        this.rentAmount = Number(this.rentAmount);
    }
    updateProps() {
        this.propertyType = 'rent-apratment';
        this.category = 'residence-rent';
    }
};
exports.RentApartment = RentApartment;
__decorate([
    (0, typeorm_1.AfterLoad)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], RentApartment.prototype, "afterLoad", null);
__decorate([
    (0, typeorm_1.BeforeInsert)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], RentApartment.prototype, "updateProps", null);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ type: "bigint", default: 0 }),
    __metadata("design:type", Number)
], RentApartment.prototype, "mortgageAmount", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ type: "bigint", default: 0 }),
    __metadata("design:type", Number)
], RentApartment.prototype, "rentAmount", void 0);
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasAbilityToChange", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], RentApartment.prototype, "meterage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'enum', example: 'penthouse | tower | suite' }),
    (0, typeorm_1.Column)({ nullable: true, type: 'varchar' }),
    __metadata("design:type", String)
], RentApartment.prototype, "buildingType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String, description: 'building age id' }),
    (0, typeorm_1.ManyToOne)(() => age_entity_1.Age, { eager: true }),
    __metadata("design:type", age_entity_1.Age)
], RentApartment.prototype, "age", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String, description: 'room number' }),
    (0, typeorm_1.ManyToOne)(() => room_entity_1.Room, { eager: true }),
    __metadata("design:type", room_entity_1.Room)
], RentApartment.prototype, "room", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => floor_number_entity_1.FloorNubmer, { eager: true }),
    __metadata("design:type", floor_number_entity_1.FloorNubmer)
], RentApartment.prototype, "floorNumber", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasGarage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasElevator", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasStoreHouse", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => total_floor_type_entity_1.TotalFloorType, { eager: true }),
    __metadata("design:type", total_floor_type_entity_1.TotalFloorType)
], RentApartment.prototype, "totalFloors", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => unit_in_each_floor_enity_1.UnitInEachFloor, { eager: true }),
    __metadata("design:type", unit_in_each_floor_enity_1.UnitInEachFloor)
], RentApartment.prototype, "unitInFloor", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 20 }),
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", Number)
], RentApartment.prototype, "totalUnits", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => builing_side_entity_1.BuildingSide, { eager: true }),
    __metadata("design:type", builing_side_entity_1.BuildingSide)
], RentApartment.prototype, "buildingSide", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => construction_entity_1.ReconstructionType, { eager: true }),
    __metadata("design:type", construction_entity_1.ReconstructionType)
], RentApartment.prototype, "reconstruct", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => flooring_material_type_entity_1.FlooringMaterialType, { eager: true }),
    __metadata("design:type", flooring_material_type_entity_1.FlooringMaterialType)
], RentApartment.prototype, "flooringMaterialType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => cabinet_entity_1.CabinetType, { eager: true }),
    __metadata("design:type", cabinet_entity_1.CabinetType)
], RentApartment.prototype, "cabinetType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => wc_entity_1.Wc, { eager: true }),
    __metadata("design:type", wc_entity_1.Wc)
], RentApartment.prototype, "wc", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => cool_system_type_entity_1.CoolingSystemType, { eager: true }),
    __metadata("design:type", cool_system_type_entity_1.CoolingSystemType)
], RentApartment.prototype, "coolingSystemType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => heat_system_type_entity_1.HeatingSystemType, { eager: true }),
    __metadata("design:type", heat_system_type_entity_1.HeatingSystemType)
], RentApartment.prototype, "heatingSystemType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => heat_water_system_entity_1.HeatWaterSystemType, { eager: true }),
    __metadata("design:type", heat_water_system_entity_1.HeatWaterSystemType)
], RentApartment.prototype, "heatWaterSystemType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasCentralAnthena", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasConferenceHall", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasBathTub", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasMasterRoom", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasBalcony", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasGazebo", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasSwimmingPool", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasRoofGarden", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasLobby", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasGamingRoom", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasSportingHall", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], RentApartment.prototype, "hasSaunaJacuzzi", void 0);
exports.RentApartment = RentApartment = __decorate([
    (0, typeorm_1.ChildEntity)(),
    __metadata("design:paramtypes", [Object])
], RentApartment);
//# sourceMappingURL=rent-apartment.js.map