import { IAge } from "../ads-params/age.entity";
import { IBuildingSide } from "../ads-params/builing-side.entity";
import { ICabinetType } from "../ads-params/cabinet.entity";
import { IReconstructionType } from "../ads-params/construction.entity";
import { ICoolSystemType } from "../ads-params/cool-system-type.entity";
import { IFloorNumber } from "../ads-params/floor-number.entity";
import { IFlooringMaterialType } from "../ads-params/flooring-material-type.entity";
import { IHeatingSystemType } from "../ads-params/heat-system-type.entity";
import { IHeatWaterSystem } from "../ads-params/heat-water-system.entity";
import { IRoom } from "../ads-params/room.entity";
import { TotalFloorType } from "../ads-params/total-floor-type.entity";
import { IUnitInEachFloor } from "../ads-params/unit-in-each-floor.enity";
import { IWC } from "../ads-params/wc.entity";
import { Advertise, IAdvertise } from "../advertise.entity";
export declare class SaleOffice extends Advertise implements ISaleOffice {
    constructor(props?: ISaleOffice);
    afterLoad(): void;
    updateProps(): void;
    totalPrice?: number;
    meterage?: number;
    buildingType?: 'administrative' | 'clinic';
    saleAsInstallment?: boolean;
    prepaymentPercent?: number;
    prepayment?: number;
    installmentAmount?: number;
    installmentNumber?: number;
    installmentPledge?: 'zamen' | 'safteh' | 'check';
    age?: IAge;
    room?: IRoom;
    floorNumber?: IFloorNumber;
    hasGarage?: boolean;
    hasElevator?: boolean;
    hasStoreHouse?: boolean;
    totalFloors?: TotalFloorType;
    unitInFloor?: IUnitInEachFloor;
    totalUnits?: number;
    buildingSide?: IBuildingSide;
    reconstruct?: IReconstructionType;
    administrativeDoc?: boolean;
    flooringMaterialType?: IFlooringMaterialType;
    cabinetType?: ICabinetType;
    wc?: IWC;
    coolingSystemType?: ICoolSystemType;
    heatingSystemType?: IHeatingSystemType;
    heatWaterSystemType?: IHeatWaterSystem;
    hasCentralAnthena?: boolean;
    hasCCTV?: boolean;
    hasAlarm?: boolean;
    hasSecurityDoor?: boolean;
    hasSecurityRoom?: boolean;
    hasInternetMast?: boolean;
    hasDinningSalon?: boolean;
    hasFireExtinguishing?: boolean;
}
export interface ISaleOffice extends IAdvertise {
    totalPrice?: number;
    meterage?: number;
    buildingType?: 'administrative' | 'clinic';
    saleAsInstallment?: boolean;
    prepaymentPercent?: number;
    prepayment?: number;
    installmentAmount?: number;
    installmentNumber?: number;
    installmentPledge?: 'zamen' | 'safteh' | 'check';
    age?: IAge;
    room?: IRoom;
    floorNumber?: IFloorNumber;
    hasGarage?: boolean;
    hasElevator?: boolean;
    hasStoreHouse?: boolean;
    totalFloors?: TotalFloorType;
    unitInFloor?: IUnitInEachFloor;
    totalUnits?: number;
    buildingSide?: IBuildingSide;
    reconstruct?: IReconstructionType;
    administrativeDoc?: boolean;
    flooringMaterialType?: IFlooringMaterialType;
    cabinetType?: ICabinetType;
    wc?: IWC;
    coolingSystemType?: ICoolSystemType;
    heatingSystemType?: IHeatingSystemType;
    heatWaterSystemType?: IHeatWaterSystem;
    hasCentralAnthena?: boolean;
    hasCCTV?: boolean;
    hasAlarm?: boolean;
    hasSecurityDoor?: boolean;
    hasSecurityRoom?: boolean;
    hasInternetMast?: boolean;
    hasDinningSalon?: boolean;
    hasFireExtinguishing?: boolean;
}
