"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaleStore = void 0;
const typeorm_1 = require("typeorm");
const age_entity_1 = require("../ads-params/age.entity");
const cool_system_type_entity_1 = require("../ads-params/cool-system-type.entity");
const doc_entity_1 = require("../ads-params/doc.entity");
const flooring_material_type_entity_1 = require("../ads-params/flooring-material-type.entity");
const heat_system_type_entity_1 = require("../ads-params/heat-system-type.entity");
const heat_water_system_entity_1 = require("../ads-params/heat-water-system.entity");
const room_entity_1 = require("../ads-params/room.entity");
const villa_total_floor_type_entity_1 = require("../ads-params/villa-total-floor-type.entity");
const wall_material_type_entity_1 = require("../ads-params/wall-material-type.entity");
const advertise_entity_1 = require("../advertise.entity");
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
let SaleStore = class SaleStore extends advertise_entity_1.Advertise {
    constructor(props) {
        super(props);
    }
    afterLoad() {
        this.totalPrice = Number(this.totalPrice);
    }
    updateProps() {
        this.propertyType = 'sale-store';
        this.category = "commercial-sale";
    }
};
exports.SaleStore = SaleStore;
__decorate([
    (0, typeorm_1.AfterLoad)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SaleStore.prototype, "afterLoad", null);
__decorate([
    (0, typeorm_1.BeforeInsert)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SaleStore.prototype, "updateProps", null);
__decorate([
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ type: "bigint", default: 0 }),
    __metadata("design:type", Number)
], SaleStore.prototype, "totalPrice", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleStore.prototype, "meterage", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleStore.prototype, "landMeterage", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleStore.prototype, "landLength", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, swagger_1.ApiProperty)({ example: 100 }),
    (0, typeorm_1.Column)({ default: 0 }),
    __metadata("design:type", Number)
], SaleStore.prototype, "landWidth", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: 'enum', example: "'farming' | 'niches' | 'workhouse'" }),
    (0, typeorm_1.Column)({ nullable: true, type: 'varchar' }),
    __metadata("design:type", String)
], SaleStore.prototype, "buildingType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => doc_entity_1.BuildingDocType, { eager: true }),
    __metadata("design:type", doc_entity_1.BuildingDocType)
], SaleStore.prototype, "docType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "isWorkhosue", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => age_entity_1.Age, { eager: true }),
    __metadata("design:type", age_entity_1.Age)
], SaleStore.prototype, "age", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => room_entity_1.Room, { eager: true }),
    __metadata("design:type", room_entity_1.Room)
], SaleStore.prototype, "room", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => villa_total_floor_type_entity_1.VillaTotalFloorType, { eager: true }),
    __metadata("design:type", villa_total_floor_type_entity_1.VillaTotalFloorType)
], SaleStore.prototype, "storeTotalFloors", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasStoreHouse", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasRoofCrane", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => flooring_material_type_entity_1.FlooringMaterialType, { eager: true }),
    __metadata("design:type", flooring_material_type_entity_1.FlooringMaterialType)
], SaleStore.prototype, "flooringMaterialType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => wall_material_type_entity_1.WallMaterialType, { eager: true }),
    __metadata("design:type", wall_material_type_entity_1.WallMaterialType)
], SaleStore.prototype, "wallMaterialType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => cool_system_type_entity_1.CoolingSystemType, { eager: true }),
    __metadata("design:type", Object)
], SaleStore.prototype, "coolingSystemType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => heat_system_type_entity_1.HeatingSystemType, { eager: true }),
    __metadata("design:type", Object)
], SaleStore.prototype, "heatingSystemType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    (0, typeorm_1.ManyToOne)(() => heat_water_system_entity_1.HeatWaterSystemType, { eager: true }),
    __metadata("design:type", Object)
], SaleStore.prototype, "heatWaterSystemType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasLift", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasShelf", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasAlarm", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasCCTV", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasElectricShutters", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasFireExtinguishing", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasSecurityRoom", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasAdministrativeRoom", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasInternetMast", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasDinningSalon", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasWeighbridge", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    (0, typeorm_1.Column)({ nullable: true, default: false }),
    __metadata("design:type", Boolean)
], SaleStore.prototype, "hasWaterWell", void 0);
exports.SaleStore = SaleStore = __decorate([
    (0, typeorm_1.ChildEntity)(),
    __metadata("design:paramtypes", [Object])
], SaleStore);
//# sourceMappingURL=sale-store.js.map