"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FixSystemUserEntity1714895869565 = void 0;
class FixSystemUserEntity1714895869565 {
    constructor() {
        this.name = 'FixSystemUserEntity1714895869565';
    }
    async up(queryRunner) {
        await queryRunner.query(`CREATE TABLE \`persons\` (\`id\` varchar(36) NOT NULL, \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`deletedAt\` datetime(6) NULL, \`firstName\` varchar(255) NOT NULL, \`lastName\` varchar(255) NOT NULL, \`nationalCode\` varchar(255) NOT NULL, \`userName\` varchar(30) NOT NULL, \`nationalCodeImg\` text NOT NULL, UNIQUE INDEX \`IDX_2c0ea8adccfc78e69db9dc65b7\` (\`userName\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`places-info\` (\`id\` varchar(36) NOT NULL, \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`deletedAt\` datetime(6) NULL, \`location\` geometry NOT NULL, \`polygon\` geometry NOT NULL, \`isCapitalCounty\` tinyint NOT NULL, \`canInsertAdvertise\` tinyint NOT NULL, \`showAdvertise\` tinyint NOT NULL, \`canInsertSpecialAdvertise\` tinyint NOT NULL, \`showSpecialAdvertise\` tinyint NOT NULL, \`canInsertCommercial\` tinyint NOT NULL, \`showCommercial\` tinyint NOT NULL, \`closeCities\` text NOT NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`places\` (\`id\` varchar(36) NOT NULL, \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`deletedAt\` datetime(6) NULL, \`name\` varchar(255) NOT NULL, \`eName\` varchar(255) NOT NULL, \`type\` enum ('country', 'province', 'county', 'city', 'area', 'union') NOT NULL, \`parentId\` varchar(36) NULL, \`infoId\` varchar(36) NULL, UNIQUE INDEX \`REL_ca6f13aa5089b41b8a910b310f\` (\`infoId\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`agencies\` (\`id\` varchar(36) NOT NULL, \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`deletedAt\` datetime(6) NULL, \`title\` varchar(255) NOT NULL, \`cityCode\` varchar(5) NOT NULL, \`phoneNumber\` varchar(20) NOT NULL, \`licenceNumber\` varchar(20) NOT NULL, \`licenceImg\` text NOT NULL, \`firstName\` varchar(255) NOT NULL, \`lastName\` varchar(255) NOT NULL, \`userName\` varchar(30) NOT NULL, \`cityId\` varchar(36) NULL, UNIQUE INDEX \`IDX_565d70c03977b53a012399d12b\` (\`userName\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`consultants\` (\`id\` varchar(36) NOT NULL, \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`deletedAt\` datetime(6) NULL, \`firstName\` varchar(255) NOT NULL, \`lastName\` varchar(255) NOT NULL, \`userName\` varchar(30) NOT NULL, UNIQUE INDEX \`IDX_af741b75f6c9d29d76b9d04710\` (\`userName\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`messages\` (\`id\` varchar(36) NOT NULL, \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`deletedAt\` datetime(6) NULL, \`code\` varchar(6) NOT NULL, \`userId\` varchar(36) NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`system-user-info\` (\`id\` varchar(36) NOT NULL, \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`deletedAt\` datetime(6) NULL, \`password\` varchar(512) NOT NULL, \`access\` text NOT NULL, PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`users\` (\`id\` varchar(36) NOT NULL, \`createdAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6), \`updatedAt\` datetime(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), \`deletedAt\` datetime(6) NULL, \`cellphone\` varchar(15) NULL, \`firstLogin\` tinyint NOT NULL DEFAULT 1, \`type\` varchar(25) NOT NULL DEFAULT 'subscriber', \`personId\` varchar(36) NULL, \`agencyId\` varchar(36) NULL, \`consultantId\` varchar(36) NULL, \`systemId\` varchar(36) NULL, UNIQUE INDEX \`REL_aab7c8e949b6e7c268872b25c0\` (\`systemId\`), PRIMARY KEY (\`id\`)) ENGINE=InnoDB`);
        await queryRunner.query(`CREATE TABLE \`agencies_areas_places\` (\`agenciesId\` varchar(36) NOT NULL, \`placesId\` varchar(36) NOT NULL, INDEX \`IDX_173803c1cac94bb590d147aac1\` (\`agenciesId\`), INDEX \`IDX_d48883ce969ef8bb68c4311b55\` (\`placesId\`), PRIMARY KEY (\`agenciesId\`, \`placesId\`)) ENGINE=InnoDB`);
        await queryRunner.query(`ALTER TABLE \`places\` ADD CONSTRAINT \`FK_2c2dee0a8f13ccf8234cbaea781\` FOREIGN KEY (\`parentId\`) REFERENCES \`places\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`places\` ADD CONSTRAINT \`FK_ca6f13aa5089b41b8a910b310f0\` FOREIGN KEY (\`infoId\`) REFERENCES \`places-info\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`agencies\` ADD CONSTRAINT \`FK_27b136302188d873872c6d03b85\` FOREIGN KEY (\`cityId\`) REFERENCES \`places\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`messages\` ADD CONSTRAINT \`FK_4838cd4fc48a6ff2d4aa01aa646\` FOREIGN KEY (\`userId\`) REFERENCES \`users\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`users\` ADD CONSTRAINT \`FK_ddd0d20e45dbd0d1536dc082039\` FOREIGN KEY (\`personId\`) REFERENCES \`persons\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`users\` ADD CONSTRAINT \`FK_184debc49e72b43579476cc6e75\` FOREIGN KEY (\`agencyId\`) REFERENCES \`agencies\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`users\` ADD CONSTRAINT \`FK_8dcf3df2511c5b9f6904c71cbaf\` FOREIGN KEY (\`consultantId\`) REFERENCES \`consultants\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`users\` ADD CONSTRAINT \`FK_aab7c8e949b6e7c268872b25c0d\` FOREIGN KEY (\`systemId\`) REFERENCES \`system-user-info\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE \`agencies_areas_places\` ADD CONSTRAINT \`FK_173803c1cac94bb590d147aac10\` FOREIGN KEY (\`agenciesId\`) REFERENCES \`agencies\`(\`id\`) ON DELETE CASCADE ON UPDATE CASCADE`);
        await queryRunner.query(`ALTER TABLE \`agencies_areas_places\` ADD CONSTRAINT \`FK_d48883ce969ef8bb68c4311b559\` FOREIGN KEY (\`placesId\`) REFERENCES \`places\`(\`id\`) ON DELETE NO ACTION ON UPDATE NO ACTION`);
    }
    async down(queryRunner) {
        await queryRunner.query(`ALTER TABLE \`agencies_areas_places\` DROP FOREIGN KEY \`FK_d48883ce969ef8bb68c4311b559\``);
        await queryRunner.query(`ALTER TABLE \`agencies_areas_places\` DROP FOREIGN KEY \`FK_173803c1cac94bb590d147aac10\``);
        await queryRunner.query(`ALTER TABLE \`users\` DROP FOREIGN KEY \`FK_aab7c8e949b6e7c268872b25c0d\``);
        await queryRunner.query(`ALTER TABLE \`users\` DROP FOREIGN KEY \`FK_8dcf3df2511c5b9f6904c71cbaf\``);
        await queryRunner.query(`ALTER TABLE \`users\` DROP FOREIGN KEY \`FK_184debc49e72b43579476cc6e75\``);
        await queryRunner.query(`ALTER TABLE \`users\` DROP FOREIGN KEY \`FK_ddd0d20e45dbd0d1536dc082039\``);
        await queryRunner.query(`ALTER TABLE \`messages\` DROP FOREIGN KEY \`FK_4838cd4fc48a6ff2d4aa01aa646\``);
        await queryRunner.query(`ALTER TABLE \`agencies\` DROP FOREIGN KEY \`FK_27b136302188d873872c6d03b85\``);
        await queryRunner.query(`ALTER TABLE \`places\` DROP FOREIGN KEY \`FK_ca6f13aa5089b41b8a910b310f0\``);
        await queryRunner.query(`ALTER TABLE \`places\` DROP FOREIGN KEY \`FK_2c2dee0a8f13ccf8234cbaea781\``);
        await queryRunner.query(`DROP INDEX \`IDX_d48883ce969ef8bb68c4311b55\` ON \`agencies_areas_places\``);
        await queryRunner.query(`DROP INDEX \`IDX_173803c1cac94bb590d147aac1\` ON \`agencies_areas_places\``);
        await queryRunner.query(`DROP TABLE \`agencies_areas_places\``);
        await queryRunner.query(`DROP INDEX \`REL_aab7c8e949b6e7c268872b25c0\` ON \`users\``);
        await queryRunner.query(`DROP TABLE \`users\``);
        await queryRunner.query(`DROP TABLE \`system-user-info\``);
        await queryRunner.query(`DROP TABLE \`messages\``);
        await queryRunner.query(`DROP INDEX \`IDX_af741b75f6c9d29d76b9d04710\` ON \`consultants\``);
        await queryRunner.query(`DROP TABLE \`consultants\``);
        await queryRunner.query(`DROP INDEX \`IDX_565d70c03977b53a012399d12b\` ON \`agencies\``);
        await queryRunner.query(`DROP TABLE \`agencies\``);
        await queryRunner.query(`DROP INDEX \`REL_ca6f13aa5089b41b8a910b310f\` ON \`places\``);
        await queryRunner.query(`DROP TABLE \`places\``);
        await queryRunner.query(`DROP TABLE \`places-info\``);
        await queryRunner.query(`DROP INDEX \`IDX_2c0ea8adccfc78e69db9dc65b7\` ON \`persons\``);
        await queryRunner.query(`DROP TABLE \`persons\``);
    }
}
exports.FixSystemUserEntity1714895869565 = FixSystemUserEntity1714895869565;
//# sourceMappingURL=1714895869565-FixSystemUserEntity.js.map