"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdvertiseControllerMixin = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const advers_service_1 = require("./advers.service");
const current_user_decorator_1 = require("../../core/decorators/current-user.decorator");
const jwt_guard_1 = require("../../core/guards/jwt-guard");
const user_entity_1 = require("../../db/entities/user.entity");
const advers_pipe_1 = require("./advers.pipe");
const advers_interceptor_1 = require("./advers.interceptor");
function AdvertiseControllerMixin(entityClass, pipe, interceptor) {
    const tagName = entityClass.name;
    class ListResponse {
    }
    __decorate([
        (0, swagger_1.ApiProperty)(),
        __metadata("design:type", Boolean)
    ], ListResponse.prototype, "status", void 0);
    __decorate([
        (0, swagger_1.ApiProperty)({ type: [entityClass] }),
        __metadata("design:type", Array)
    ], ListResponse.prototype, "data", void 0);
    class MessageResponse {
    }
    __decorate([
        (0, swagger_1.ApiProperty)(),
        __metadata("design:type", Boolean)
    ], MessageResponse.prototype, "status", void 0);
    __decorate([
        (0, swagger_1.ApiProperty)({ type: String }),
        __metadata("design:type", String)
    ], MessageResponse.prototype, "message", void 0);
    let GenericController = class GenericController {
        constructor(srv) {
            this.srv = srv;
        }
        async signle(id) {
            return await this.srv.single(tagName, id);
        }
        async upsert(dto, user) {
            return await this.srv.upsert(tagName, dto, user);
        }
        async remove(id, user) {
            return await this.srv.remove(tagName, id);
        }
    };
    __decorate([
        (0, common_1.Get)(':id'),
        (0, swagger_1.ApiOkResponse)({ type: entityClass }),
        (0, common_1.UseInterceptors)(interceptor || advers_interceptor_1.AdversInterceptor),
        __param(0, (0, common_1.Param)('id')),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
    ], GenericController.prototype, "signle", null);
    __decorate([
        (0, common_1.Post)(),
        (0, swagger_1.ApiBody)({ type: entityClass }),
        (0, swagger_1.ApiResponse)({ type: MessageResponse }),
        __param(0, (0, common_1.Body)(pipe || advers_pipe_1.AdversPipe)),
        __param(1, (0, current_user_decorator_1.CurrentUser)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object, user_entity_1.UserEntity]),
        __metadata("design:returntype", Promise)
    ], GenericController.prototype, "upsert", null);
    __decorate([
        (0, common_1.Delete)(':id'),
        (0, swagger_1.ApiResponse)({ type: MessageResponse }),
        __param(0, (0, common_1.Param)('id')),
        __param(1, (0, current_user_decorator_1.CurrentUser)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, user_entity_1.UserEntity]),
        __metadata("design:returntype", Promise)
    ], GenericController.prototype, "remove", null);
    GenericController = __decorate([
        (0, swagger_1.ApiTags)(tagName.split(/\.?(?=[A-Z])/).join(' ')),
        (0, common_1.UseGuards)(jwt_guard_1.JwtAuthGuard),
        (0, swagger_1.ApiBearerAuth)('access-token'),
        __metadata("design:paramtypes", [advers_service_1.AdvertisService])
    ], GenericController);
    (0, common_1.Controller)(`advertise/${tagName
        .split(/\.?(?=[A-Z])/)
        .join('-')
        .toLowerCase()}`)(GenericController);
    return GenericController;
}
exports.AdvertiseControllerMixin = AdvertiseControllerMixin;
//# sourceMappingURL=advers.controller.js.map