"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthModule = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const jwt_1 = require("@nestjs/jwt");
const auth_controller_1 = require("./auth.controller");
const jwt_strategy_1 = require("./strategies/jwt.strategy");
const handlers_1 = require("./handlers");
const cqrs_1 = require("@nestjs/cqrs");
const sms_service_1 = require("./sms.service");
const admin_auth_controller_1 = require("./admin-auth.controller");
let AuthModule = class AuthModule {
};
exports.AuthModule = AuthModule;
exports.AuthModule = AuthModule = __decorate([
    (0, common_1.Module)({
        imports: [
            cqrs_1.CqrsModule,
            passport_1.PassportModule.register({ defaultStrategy: 'jwt' }),
            jwt_1.JwtModule.register({
                secret: 'secret'
            })
        ],
        providers: [jwt_strategy_1.JwtStrategy, handlers_1.LoginHandler, handlers_1.VerifyHandler, sms_service_1.SMSService, handlers_1.AdminLoginCommandHandler],
        controllers: [auth_controller_1.AuthController, admin_auth_controller_1.AdminAuthController]
    })
], AuthModule);
//# sourceMappingURL=auth.module.js.map