"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VerifyHandler = exports.VerifyCommand = void 0;
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const dict_1 = require("../../../../constants/dict");
const jwt_1 = require("@nestjs/jwt");
const common_1 = require("@nestjs/common");
const { users, messages } = repositories_1.default;
class VerifyCommand {
    constructor(dto) {
        this.dto = dto;
    }
}
exports.VerifyCommand = VerifyCommand;
let VerifyHandler = class VerifyHandler {
    constructor(jwt) {
        this.jwt = jwt;
    }
    async execute(command) {
        const { cellphone, code } = command.dto;
        let user = await users.findOneBy({ cellphone });
        const message = await messages
            .createQueryBuilder('message')
            .leftJoinAndSelect('message.user', 'user')
            .where('user.cellphone = :cellphone', { cellphone })
            .orderBy({ 'message.createdAt': 'DESC' })
            .getOne();
        if (code !== message.code)
            throw new common_1.BadRequestException(dict_1.default.CODE_IS_NOT_CORRECT);
        delete user.password;
        const payload = {
            id: user.id,
        };
        return {
            token: this.jwt.sign(payload),
            user,
        };
    }
};
exports.VerifyHandler = VerifyHandler;
exports.VerifyHandler = VerifyHandler = __decorate([
    (0, cqrs_1.CommandHandler)(VerifyCommand),
    __metadata("design:paramtypes", [jwt_1.JwtService])
], VerifyHandler);
//# sourceMappingURL=VerifyCommand.js.map