"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeletePlaceHandler = exports.DeletePlaceCommand = void 0;
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const place_entity_1 = require("../../../../db/entities/place.entity");
const handled_error_1 = require("../../../../core/classes/handled-error");
const dict_1 = require("../../../../constants/dict");
const places = repositories_1.db.getRepository(place_entity_1.PlaceEntity);
class DeletePlaceCommand {
    constructor(id) {
        this.id = id;
    }
}
exports.DeletePlaceCommand = DeletePlaceCommand;
let DeletePlaceHandler = class DeletePlaceHandler {
    async execute(command) {
        const { id } = command || {};
        const place = await places.findOneBy({ id });
        if (!place)
            throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
        await place.softRemove();
        return dict_1.default.SUCCESS_MESSAGE;
    }
};
exports.DeletePlaceHandler = DeletePlaceHandler;
exports.DeletePlaceHandler = DeletePlaceHandler = __decorate([
    (0, cqrs_1.CommandHandler)(DeletePlaceCommand)
], DeletePlaceHandler);
//# sourceMappingURL=DeletePlace.js.map