import { ICommandHandler } from '@nestjs/cqrs';
import { LocationAddressModel } from '~model/address';
import { UserEntity } from '~db/entities/user.entity';
export declare class UpsertAgencyUserCommand {
    dto: UpsertAgencyUserRequestModel;
    user: UserEntity;
    constructor(dto: UpsertAgencyUserRequestModel, user: UserEntity);
}
export declare class UpsertAgencyUserHandler implements ICommandHandler<UpsertAgencyUserCommand> {
    execute({ user: current, dto }: UpsertAgencyUserCommand): Promise<any>;
}
export declare class UpsertAgencyUserRequestModel {
    title: string;
    cityCode: string;
    phoneNumber: string;
    licenseNumber: string;
    licenseImg: string;
    firstName: string;
    address: LocationAddressModel;
    lastName: string;
    userName: string;
    cityId: string;
    areasId: string[];
}
