"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpsertAgencyUserRequestModel = exports.UpsertAgencyUserHandler = exports.UpsertAgencyUserCommand = void 0;
const swagger_1 = require("@nestjs/swagger");
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const dict_1 = require("../../../../constants/dict");
const place_entity_1 = require("../../../../db/entities/place.entity");
const typeorm_1 = require("typeorm");
const address_1 = require("../../../../model/address");
const handled_error_1 = require("../../../../core/classes/handled-error");
const user_entity_1 = require("../../../../db/entities/user.entity");
const agency_entity_1 = require("../../../../db/entities/user/agency.entity");
const class_validator_1 = require("class-validator");
const agencies = repositories_1.db.getRepository(agency_entity_1.AgencyEntity);
const places = repositories_1.db.getRepository(place_entity_1.PlaceEntity);
class UpsertAgencyUserCommand {
    constructor(dto, user) {
        this.dto = dto;
        this.user = user;
    }
}
exports.UpsertAgencyUserCommand = UpsertAgencyUserCommand;
let UpsertAgencyUserHandler = class UpsertAgencyUserHandler {
    async execute({ user: current, dto }) {
        const { cityId, areasId, title, userName, ...rest } = dto;
        const city = await places.findOneBy({ id: cityId });
        const areas = await places.findBy({
            id: (0, typeorm_1.In)(areasId),
        });
        if (current.subscriberType === 'none') {
            const userNameExist = await agencies.findOneBy({
                userName: dto.userName,
            });
            if (userNameExist)
                throw new handled_error_1.HandledError(dict_1.default.USERNAME_EXIST);
            await repositories_1.db.manager.update(user_entity_1.UserEntity, { id: current.id }, {
                ...rest,
                city,
                areas,
                subscriberType: 'agency',
                type: 'AgencyEntity',
            });
        }
        else {
            const userNameExist = await agencies.findOneBy({
                id: (0, typeorm_1.Not)(current.id),
                userName: dto.userName,
            });
            if (userNameExist)
                throw new handled_error_1.HandledError(dict_1.default.USERNAME_EXIST);
            const agency = await agencies.findOneBy({ id: current.id });
            agency.update({ ...rest, city, areas });
            await agency.save();
        }
        return dict_1.default.SUCCESS_MESSAGE;
    }
};
exports.UpsertAgencyUserHandler = UpsertAgencyUserHandler;
exports.UpsertAgencyUserHandler = UpsertAgencyUserHandler = __decorate([
    (0, cqrs_1.CommandHandler)(UpsertAgencyUserCommand)
], UpsertAgencyUserHandler);
class UpsertAgencyUserRequestModel {
}
exports.UpsertAgencyUserRequestModel = UpsertAgencyUserRequestModel;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertAgencyUserRequestModel.prototype, "title", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertAgencyUserRequestModel.prototype, "cityCode", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertAgencyUserRequestModel.prototype, "phoneNumber", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertAgencyUserRequestModel.prototype, "licenseNumber", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertAgencyUserRequestModel.prototype, "licenseImg", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertAgencyUserRequestModel.prototype, "firstName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: address_1.LocationAddressModel }),
    __metadata("design:type", address_1.LocationAddressModel)
], UpsertAgencyUserRequestModel.prototype, "address", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertAgencyUserRequestModel.prototype, "lastName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertAgencyUserRequestModel.prototype, "userName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertAgencyUserRequestModel.prototype, "cityId", void 0);
__decorate([
    (0, class_validator_1.IsArray)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", Array)
], UpsertAgencyUserRequestModel.prototype, "areasId", void 0);
//# sourceMappingURL=UpsertAgencyUser.js.map