"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpsertSystemUserRequestModel = exports.UpsertSystemHandler = exports.UpsertSystemUserCommand = void 0;
const swagger_1 = require("@nestjs/swagger");
const cqrs_1 = require("@nestjs/cqrs");
const password_1 = require("../../../../config/password");
const dict_1 = require("../../../../constants/dict");
const repositories_1 = require("../../../../db/repositories");
const handled_error_1 = require("../../../../core/classes/handled-error");
const user_entity_1 = require("../../../../db/entities/user.entity");
const users = repositories_1.db.getRepository(user_entity_1.UserEntity);
class UpsertSystemUserCommand {
    constructor(dto) {
        this.dto = dto;
    }
}
exports.UpsertSystemUserCommand = UpsertSystemUserCommand;
let UpsertSystemHandler = class UpsertSystemHandler {
    async execute(command) {
        const { firstName, lastName, id, password: _pass, cellphone, } = command.dto || {};
        if (id) {
            const user = await users.findOneBy({ id });
            if (!user)
                throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
            user.firstName = firstName;
            user.lastName = lastName;
            await user.save();
            return dict_1.default.SUCCESS_MESSAGE;
        }
        else {
            const password = await (0, password_1.hash)(_pass);
            const user = new user_entity_1.UserEntity({
                firstName,
                lastName,
                password,
                cellphone,
                isSystemUser: true,
            });
            await user.save();
            return dict_1.default.SUCCESS_MESSAGE;
        }
    }
};
exports.UpsertSystemHandler = UpsertSystemHandler;
exports.UpsertSystemHandler = UpsertSystemHandler = __decorate([
    (0, cqrs_1.CommandHandler)(UpsertSystemUserCommand)
], UpsertSystemHandler);
class UpsertSystemUserRequestModel {
}
exports.UpsertSystemUserRequestModel = UpsertSystemUserRequestModel;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertSystemUserRequestModel.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertSystemUserRequestModel.prototype, "cellphone", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertSystemUserRequestModel.prototype, "firstName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertSystemUserRequestModel.prototype, "lastName", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertSystemUserRequestModel.prototype, "password", void 0);
//# sourceMappingURL=UpsertSystemUser.js.map