"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const cqrs_1 = require("@nestjs/cqrs");
const handlers_1 = require("./handlers");
const current_user_decorator_1 = require("../../core/decorators/current-user.decorator");
const jwt_guard_1 = require("../../core/guards/jwt-guard");
const user_entity_1 = require("../../db/entities/user.entity");
let UserController = class UserController {
    constructor(command, queryBus) {
        this.command = command;
        this.queryBus = queryBus;
    }
    async upsertAgency(data, user) {
        return await this.command.execute(new handlers_1.UpsertAgencyUserCommand(data, user));
    }
    async upsertConsultant(data, user) {
        return await this.command.execute(new handlers_1.UpsertConsultantUserCommand(data, user));
    }
    async upsertPersonal(data, user) {
        return await this.command.execute(new handlers_1.UpsertPersonalUserCommand(data, user));
    }
    async getCurrentUer(user) {
        return user;
    }
};
exports.UserController = UserController;
__decorate([
    (0, common_1.Post)('agency'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [handlers_1.UpsertAgencyUserRequestModel,
        user_entity_1.UserEntity]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "upsertAgency", null);
__decorate([
    (0, common_1.Post)('consultant'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [handlers_1.UpsertConsultantUserRequestModel,
        user_entity_1.UserEntity]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "upsertConsultant", null);
__decorate([
    (0, common_1.Post)('personal'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [handlers_1.UpsertPersonalUserRequestModel,
        user_entity_1.UserEntity]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "upsertPersonal", null);
__decorate([
    (0, common_1.Get)(''),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.UserEntity]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "getCurrentUer", null);
exports.UserController = UserController = __decorate([
    (0, common_1.UseGuards)(jwt_guard_1.JwtAuthGuard),
    (0, swagger_1.ApiTags)('User'),
    (0, common_1.Controller)('user'),
    (0, swagger_1.ApiBearerAuth)('access-token'),
    __metadata("design:paramtypes", [cqrs_1.CommandBus,
        cqrs_1.QueryBus])
], UserController);
//# sourceMappingURL=user.controller.js.map