import { createParamDecorator, ExecutionContext } from '@nestjs/common';
import { UserEntity } from '~db/entities/user.entity';

export const CurrentUser = createParamDecorator(
  (_data: unknown, ctx: ExecutionContext): UserEntity => {
    const req = ctx.switchToHttp().getRequest();

    return req?.user || {};
  }
);
