import { AfterLoad, BeforeInsert, ChildEntity, Column, ManyToOne } from "typeorm";
import { Age, IAge } from "../ads-params/age.entity";
import { BuildingSide, IBuildingSide } from "../ads-params/builing-side.entity";
import { CabinetType, ICabinetType } from "../ads-params/cabinet.entity";
import { IReconstructionType, ReconstructionType } from "../ads-params/construction.entity";
import { CoolingSystemType, ICoolSystemType } from "../ads-params/cool-system-type.entity";
import { FlooringMaterialType, IFlooringMaterialType } from "../ads-params/flooring-material-type.entity";
import { HeatingSystemType, IHeatingSystemType } from "../ads-params/heat-system-type.entity";
import { HeatWaterSystemType, IHeatWaterSystem } from "../ads-params/heat-water-system.entity";
import { IRoom, Room } from "../ads-params/room.entity";
import { TotalFloorType } from "../ads-params/total-floor-type.entity";
import { IUnitInEachFloor } from "../ads-params/unit-in-each-floor.enity";
import { IVillaTotalFloorType, VillaTotalFloorType } from "../ads-params/villa-total-floor-type.entity";
import { IWC, Wc } from "../ads-params/wc.entity";
import { Advertise, IAdvertise } from "../advertise.entity";
import { IsBoolean, IsNotEmpty, IsNumber } from "class-validator";
import { ApiProperty } from "@nestjs/swagger";
import { BuildingDocType } from "../ads-params/doc.entity";

@ChildEntity()
export class RentVilla extends Advertise implements IAdvertise {
  constructor(props?: IRentVilla) {
    super(props);
  }

  @AfterLoad()
  afterLoad() {
    this.mortgageAmount= Number(this.mortgageAmount); 
    this.rentAmount= Number(this.rentAmount); 
  }

  @BeforeInsert()
  updateProps() {
    this.propertyType = 'rent-villa';
    this.category = 'residence-rent';
  }

  @IsNumber()
  @ApiProperty()
  @Column({type: "bigint", default: 0})
  mortgageAmount?: number;

  @IsNumber()
  @ApiProperty()
  @Column({type: "bigint", default: 0})
  rentAmount?: number;

  @IsBoolean()
  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasAbilityToChange?: boolean;

  @ApiProperty({ type: 'enum', example: "'villa-garden' | 'garden' | 'villa'" })
  @Column({ nullable: true, type: 'varchar' })
  buildingType?: 'villa-garden' | 'garden' | 'villa';

  @IsNotEmpty()
  @IsNumber()
  @ApiProperty()
  @Column({default: 0})
  landMeterage?: number;

  @IsNotEmpty()
  @IsNumber()
  @ApiProperty()
  @Column({default: 0})
  buildingMeterage?: number;

  @ApiProperty({ type: String, description: 'building age id' })
  @ManyToOne(() => Age)
  age?: Age;

  @ApiProperty({ type: String, description: 'room number' })
  @ManyToOne(() => Room)
  room: Room;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGarage?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasStoreHouse?: boolean;

  @ApiProperty({ type: String })
  @ManyToOne(() => VillaTotalFloorType)
  villaTotalFloors: VillaTotalFloorType;

  @ApiProperty({ type: String })
  @ManyToOne(() => BuildingSide)
  buildingSide?: BuildingSide;

  @ApiProperty({type: String})
  @ManyToOne(() => ReconstructionType)
  reconstruct?: ReconstructionType;

  @ApiProperty({ type: String })
  @ManyToOne(() => FlooringMaterialType)
  flooringMaterialType?: FlooringMaterialType;

  @ApiProperty({ type: String })
  @ManyToOne(() => CabinetType)
  cabinetType?: CabinetType;

  @ApiProperty({ type: String })
  @ManyToOne(() => Wc)
  wc?: Wc;

  @ApiProperty({ type: String })
  @ManyToOne(() => CoolingSystemType)
  coolingSystemType?: CoolingSystemType;

  @ApiProperty({ type: String })
  @ManyToOne(() => HeatingSystemType)
  heatingSystemType?: HeatingSystemType;

  @ApiProperty({ type: String })
  @ManyToOne(() => HeatWaterSystemType)
  heatWaterSystemType?: HeatWaterSystemType;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasCentralAnthena?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasConferenceHall?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasBathTub?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasMasterRoom?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasBalcony?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGazebo?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSwimmingPool?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasRoofGarden?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasLobby?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasGamingRoom?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSportingHall?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  hasSaunaJacuzzi?: boolean;
}

export interface IRentVilla extends IAdvertise {
  mortgageAmount?: number;
  rentAmount?: number;
  hasAbilityToChange?: number;
  landMeterage?: number;
  buildingMeterage?: number;
  villaTotalFloors?: IVillaTotalFloorType;
  buildingType?: 'villa-garden' | 'garden' | 'villa';
  age?: IAge;
  room?: IRoom;
  hasGarage?: boolean;
  hasStoreHouse?: boolean;
  totalFloors?: TotalFloorType;
  unitInFloor?: IUnitInEachFloor;
  totalUnits?: number;
  buildingSide?: IBuildingSide;
  reconstruct?: IReconstructionType;
  flooringMaterialType?: IFlooringMaterialType;
  cabinetType?: ICabinetType;
  wc?: IWC;
  coolingSystemType?: ICoolSystemType;
  heatingSystemType?: IHeatingSystemType;
  heatWaterSystemType?: IHeatWaterSystem;
  hasCentralAnthena?: boolean;
  hasConferenceHall?: boolean;
  hasBathTub?: boolean;
  hasMasterRoom?: boolean;
  hasBalcony?: boolean;
  hasGazebo?: boolean;
  hasSwimmingPool?: boolean;
  hasRoofGarden?: boolean;
  hasLobby?: boolean;
  hasGamingRoom?: boolean;
  hasSportingHall?: boolean;
}