import { LocationAddressModel } from '../../model/address';
import { IPlaceEntity, PlaceEntity } from './place.entity';
import {
  Column,
  Entity,
  ManyToOne,
  TableInheritance,
} from 'typeorm';
import { SharedEntity } from './shared.entity';
import { ApiProperty } from '@nestjs/swagger';
import { IUserEntity, UserEntity } from './user.entity';

@Entity({ name: 'advertises' })
@TableInheritance({ column: { type: 'varchar', name: 'type' } })
export class Advertise extends SharedEntity<IAdvertise> implements IAdvertise {
  constructor(props?: IAdvertise) {
    super(props);
  }

  @Column({
    type: 'enum',
    enum: [
      'residence-sale',
      'residence-rent',
      'commercial-sale',
      'commercial-rent',
      'short-term-rent',
      'construction',
    ],
    select: false
  })
  category?:
    | 'residence-sale'
    | 'residence-rent'
    | 'commercial-sale'
    | 'commercial-rent'
    | 'short-term-rent'
    | 'construction';

  @Column({ nullable: true, type: 'varchar', select: false })
  propertyType?: string;

  @ApiProperty({ name: 'cityId', type: String })
  @ManyToOne(() => PlaceEntity, {eager: true})
  city?: PlaceEntity;

  @ApiProperty({ name: 'districtId', type: String })
  @ManyToOne(() => PlaceEntity, {eager: true})
  district?: PlaceEntity;

  @ApiProperty({ type: LocationAddressModel })
  @Column({ nullable: true, type: 'json' })
  location?: any;

  @ApiProperty()
  @Column({ nullable: true, type: 'text' })
  thumbnail?: string;

  @ApiProperty()
  @Column({ nullable: true, type: 'simple-array' })
  images?: string[];

  @ApiProperty()
  @Column({ nullable: true, type: 'varchar' })
  subject?: string;

  @ApiProperty()
  @Column({ nullable: true, type: 'varchar' })
  title?: string;

  @ApiProperty()
  @Column({ nullable: true, type: 'text' })
  description?: string;

  @ApiProperty()
  @Column({ nullable: true, default: false })
  showContactInfo?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: true })
  canChat?: boolean;

  @ApiProperty()
  @Column({ nullable: true, default: true })
  sendToAgencyAndConsultUser?: boolean;

  @ManyToOne(() => UserEntity)
  advertizer: UserEntity;
}

export interface IAdvertise {
  category?:
    | 'residence-sale'
    | 'residence-rent'
    | 'commercial-sale'
    | 'commercial-rent'
    | 'short-term-rent'
    | 'construction';
  city?: IPlaceEntity;
  district?: IPlaceEntity;
  location?: any;
  thumbnail?: string | null;
  images?: string[];
  subject?: string;
  title?: string;
  description?: string;
  advertizer?: IUserEntity;
  showContactInfo?: boolean;
  canChat?: boolean;
  sendToAgencyAndConsultUser?: boolean;
}
