import { ChildEntity, Column } from 'typeorm';
import { IUserEntity, UserEntity } from '../user.entity';

@ChildEntity()
export class PersonEntity extends UserEntity implements IPersonEntity {
  constructor(props?: IPersonEntity) {
    super(props);
    this.subscriberType = 'personal';
  }

  @Column()
  firstName?: string;

  @Column()
  lastName?: string;

  @Column()
  nationalCode?: string;

  @Column({ nullable: true, type: 'text' })
  nationalCardImg?: string;
}

export interface IPersonEntity extends IUserEntity {
  firstName?: string;

  lastName?: string;

  nationalCode?: string;

  nationalCardImg?: string;
}
