import { DataSource } from 'typeorm';
import { Seeder } from 'typeorm-extension';
import { hash } from '../../config/password';
import { UserEntity } from '~db/entities/user.entity';

export class AdminSeeder implements Seeder {
  track?: boolean;
  async run(dataSource: DataSource): Promise<any> {
    const users = dataSource.getRepository(UserEntity);
    const userName: string = '09124251252';

    let user = await users.findOneBy({ cellphone: userName });

    if (!user) {
      const password = await hash('khanehaval2024');
      user = new UserEntity({
        password,
        isSystemUser: true,
        cellphone: userName,
      });

      await user.save();
    }
  }
}
