import { DataSource } from 'typeorm';
import { Seeder } from 'typeorm-extension';
import { Age } from '~db/entities/ads-params/age.entity';

export class AgeSeeder implements Seeder {
  track?: boolean;
  async run(dataSource: DataSource): Promise<any> {
    const _ages = dataSource.getRepository(Age);

    const ages = await _ages.find();

    if (ages.length === 0) {
      const age = new Age({
        value: 5,
      });

      await age.save();
    }
  }
}
