import { Module } from '@nestjs/common';
import { PassportModule } from '@nestjs/passport';
import { JwtModule } from '@nestjs/jwt';
import { AuthController } from '~modules/auth/auth.controller';
import { JwtStrategy } from '~modules/auth/strategies/jwt.strategy';
import { AdminLoginCommandHandler, LoginHandler, VerifyHandler } from '~modules/auth/handlers';
import { CqrsModule } from '@nestjs/cqrs';
import { SMSService } from '~modules/auth/sms.service';
import { AdminAuthController } from '~modules/auth/admin-auth.controller';

@Module({
  imports: [
    CqrsModule,
    PassportModule.register({defaultStrategy: 'jwt'}),
    JwtModule.register({
      secret: 'secret'
    })
  ],
  providers: [JwtStrategy, LoginHandler, VerifyHandler, SMSService, AdminLoginCommandHandler],
  controllers: [AuthController, AdminAuthController]
})
export class AuthModule {}