import { BadGatewayException, Injectable } from '@nestjs/common';
import { PassportStrategy } from '@nestjs/passport';
import { ExtractJwt, Strategy } from 'passport-jwt';
import r from '~db/repositories';
import { IJwtPayload } from '../models/jwt-payload';

const { users } = r;
@Injectable()
export class JwtStrategy extends PassportStrategy(Strategy, 'jwt') {
  constructor() {
    super({
      jwtFromRequest: ExtractJwt.fromAuthHeaderAsBearerToken(),
      ignoreExpiration: true,
      secretOrKey: 'secret',
    });
  }

  async validate({ id }: IJwtPayload) {
    const user = await users.findOne({
      where: { id },
    });

    if (!user) throw new BadGatewayException('error');

    return user;
  }
}
