import { Module } from '@nestjs/common';
import { CurdService } from './crud/crud.service';
import { GenericControllerMixin } from './crud/crud.controller';
import { AdsParams } from '~db/entities/ads-params';

const controllers = AdsParams.map((x: any) =>
  GenericControllerMixin(
    x,
    x.name
      .split(/\.?(?=[A-Z])/)
      .join('-')
      .toLowerCase()
  )
);

@Module({
  controllers,
  providers: [CurdService],
})
export class BaseModule {}
