import { CommandHandler, ICommandHandler } from '@nestjs/cqrs';
import { db } from '~db/repositories';
import { PlaceEntity } from '~db/entities/place.entity';
import { HandledError } from '~core/classes/handled-error';
import Dict from '~constants/dict';

const places = db.getRepository(PlaceEntity);
export class DeletePlaceCommand {
  constructor(public id: string) {}
}

@CommandHandler(DeletePlaceCommand)
export class DeletePlaceHandler implements ICommandHandler<DeletePlaceCommand> {
  async execute(command: DeletePlaceCommand): Promise<any> {
    const { id } = command || {};

    const place = await places.findOneBy({ id });

    if (!place) throw new HandledError(Dict.RECORDE_DOES_NOT_EkXIST);

    await place.softRemove();

    return Dict.SUCCESS_MESSAGE;
  }
}
