import { IQueryHandler, QueryHandler } from '@nestjs/cqrs';
import { db } from '~db/repositories';
import { PlaceEntity, PlacesType } from '~db/entities/place.entity';
import { ApiProperty } from '@nestjs/swagger';
import { QueryModel } from '~model/query';

const places = db.getRepository(PlaceEntity);
export class GetPlacesListQuery {
  constructor(public dto?: GetPlacesListRequest) {}
}

@QueryHandler(GetPlacesListQuery)
export class GetPlacesListHandler implements IQueryHandler<GetPlacesListQuery> {
  async execute({ dto }: GetPlacesListQuery): Promise<any> {
    const { offset, size, parent, type } = dto || {};
    let query = places
      .createQueryBuilder('place')
      .leftJoinAndSelect('place.parent', 'parent')
      .select(['place', 'parent']);

    if (type) {
      query = query.andWhere('place.type = :type', { type });
    }

    if (parent) {
      query = query.andWhere('parent.id= :parent', { parent });
    }

    if (size) {
      query = query.paginate({ offset, size });
    }

    let [list, total] = await Promise.all([query.getMany(), query.getCount()]);

    return {
      list,
      total,
    };
  }
}
export interface GetPlacesListResponse {}
export class GetPlacesListRequest extends QueryModel {
  @ApiProperty({
    enum: ['country', 'province', 'city', 'country', 'area', 'union'],
    required: false,
  })
  type?: PlacesType;

  @ApiProperty({
    required: false,
  })
  parent?: string;
}
