import { IPlaceInfoEntity } from '~db/entities/place-info.entity';
import {
  IPlaceEntity,
  PlaceEntity,
  PlacesType,
} from '~db/entities/place.entity';
import { ApiProperty } from '@nestjs/swagger';
import { IQueryHandler, QueryHandler } from '@nestjs/cqrs';
import { db } from '~db/repositories';

const _places = db.getRepository(PlaceEntity);
export class GetSinglePlaceQuery {
  constructor(public id: string) {}
}

@QueryHandler(GetSinglePlaceQuery)
export class GetSinglePlaceHandler
  implements IQueryHandler<GetSinglePlaceQuery>
{
  async execute({ id }: GetSinglePlaceQuery): Promise<any> {
    const item = await _places.findOne({
      where: { id },
      relations: {
        info: true,
        parent: true,
      },
    });

    return item;
  }
}

export class GetSinglePlaceResponse implements IPlaceEntity {
  @ApiProperty()
  name: string;

  @ApiProperty()
  eName: string;

  @ApiProperty()
  type: PlacesType;

  @ApiProperty()
  parent?: IPlaceEntity;

  @ApiProperty()
  children?: IPlaceEntity[];

  @ApiProperty()
  info?: IPlaceInfoEntity;
}
