import { Controller, Get, Query, UseGuards } from '@nestjs/common';
import { ApiBearerAuth, ApiTags } from '@nestjs/swagger';
import { QueryBus } from '@nestjs/cqrs';
import {
  GetPlacesListQuery,
  GetPlacesListRequest,
} from '~modules/place/handlers';
import { JwtAuthGuard } from '~core/guards/jwt-guard';

@UseGuards(JwtAuthGuard)
@ApiBearerAuth('access-token')
@ApiTags('Place')
@Controller('place')
export class PlaceController {
  constructor(private readonly queryBus: QueryBus) {}

  @Get('')
  async getCities(@Query() query: GetPlacesListRequest) {
    return await this.queryBus.execute(new GetPlacesListQuery(query));
  }
}
