import { ApiOkResponse, ApiTags } from '@nestjs/swagger';
import { Body, Controller, Get, Param, Post } from '@nestjs/common';
import { ProjectService } from '~modules/projects/services/project.service';

@ApiTags('Projects')
@Controller('projects')
export class ProjectController {
  constructor(private readonly pService: ProjectService) {}

  @Get('')
  @ApiOkResponse({
    description: 'address: 418',
  })
  async getProjectList() {
    return await this.pService.list();
  }

  @Get('content/:id')
  @ApiOkResponse({
    description: 'address: 334',
  })
  getProjectContent(@Param('id') id: string) {
    return this.pService.content(id);
  }

  @Get('/:title')
  @ApiOkResponse({
    description: 'address: 1950',
  })
  getProjectData(@Param('title') title: string) {
    return this.pService.projectData(title);
  }

  @Get('sales-condition/:id')
  @ApiOkResponse({
    description: 'address: 1949',
  })
  getSalesCondition(@Param('id') id: string) {
    return this.pService.salesCondition(id);
  }

  @Post('consult')
  @ApiOkResponse({
    description: 'address: 371',
  })
  sendConsultantForm(@Body() data: any) {
    return this.pService.sendConsultForm(data);
  }

  @Get('project-types/:code')
  @ApiOkResponse({
    description: 'address: 1948',
  })
  getProjectTypes(@Param('code') code: string) {
    return this.pService.getProjectType(code);
  }
}
