import { ApiProperty } from '@nestjs/swagger';
import { CommandHandler, ICommandHandler } from '@nestjs/cqrs';
import { hash } from '../../../../config/password';
import Dict from '~constants/dict';
import { db } from '~db/repositories';
import { HandledError } from '~core/classes/handled-error';
import { UserEntity } from '~db/entities/user.entity';

const users = db.getRepository(UserEntity);

export class UpsertSystemUserCommand {
  constructor(public dto: UpsertSystemUserRequestModel) {}
}

@CommandHandler(UpsertSystemUserCommand)
export class UpsertSystemHandler
  implements ICommandHandler<UpsertSystemUserCommand>
{
  async execute(command: UpsertSystemUserCommand): Promise<any> {
    const {
      firstName,
      lastName,
      id,
      password: _pass,
      cellphone,
    } = command.dto || {};

    if (id) {
      const user = await users.findOneBy({ id });

      if (!user) throw new HandledError(Dict.RECORDE_DOES_NOT_EkXIST);

      user.firstName = firstName;
      user.lastName = lastName;
      await user.save();

      return Dict.SUCCESS_MESSAGE;
    } else {
      //insert
      const password = await hash(_pass);
      const user = new UserEntity({
        firstName,
        lastName,
        password,
        cellphone,
        isSystemUser: true,
      });
      await user.save();

      return Dict.SUCCESS_MESSAGE;
    }
  }
}

export class UpsertSystemUserRequestModel {
  @ApiProperty()
  id?: string;

  @ApiProperty()
  cellphone?: string;

  @ApiProperty()
  firstName?: string;

  @ApiProperty()
  lastName?: string;

  @ApiProperty()
  password?: string;
}
