import { IQueryHandler, QueryHandler } from '@nestjs/cqrs';
import { UserEntity } from '~db/entities/user.entity';
import r from '~db/repositories';

const { users } = r;

export class GetCurrentUserQuery {
  constructor(public user: UserEntity) {}
}

@QueryHandler(GetCurrentUserQuery)
export class GetCurrentUserHandler
  implements IQueryHandler<GetCurrentUserQuery>
{
  async execute(props: GetCurrentUserQuery): Promise<any> {
    const { user } = props;

    const current = await users
      .createQueryBuilder('user')
      .leftJoinAndSelect('agency.city', 'city')
      .leftJoinAndSelect('agency.areas', 'areas')
      .leftJoinAndSelect('user.system', 'system')
      .select(['user'])
      .where('user.id = :id', { id: user.id })
      .getOne();

    delete current.password;

    return current;
  }
}
