"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const user_module_1 = require("./modules/users/user.module");
const auth_module_1 = require("./modules/auth/auth.module");
const upload_module_1 = require("./modules/upload/upload.module");
const logger_middleware_1 = require("./core/middlewares/logger.middleware");
const place_module_1 = require("./modules/place/place.module");
const project_module_1 = require("./modules/projects/project.module");
const core_module_1 = require("./core/core.module");
const config_1 = require("@nestjs/config");
const map_module_1 = require("./modules/map/map.module");
const serve_static_1 = require("@nestjs/serve-static");
const path_1 = require("path");
const base_1 = require("./modules/base");
const advertise_module_1 = require("./modules/advertise/advertise.module");
let AppModule = class AppModule {
    configure(consumer) {
        consumer.apply(logger_middleware_1.LoggerMiddleware).forRoutes('*');
    }
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot(),
            serve_static_1.ServeStaticModule.forRoot({
                rootPath: (0, path_1.join)(__dirname, '..', 'uploads'),
            }),
            auth_module_1.AuthModule,
            user_module_1.UserModule,
            upload_module_1.UploadModule,
            place_module_1.PlaceModule,
            project_module_1.ProjectModule,
            core_module_1.CoreModule,
            map_module_1.MapModule,
            base_1.BaseModule,
            advertise_module_1.AdvertiseModule
        ],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map