import { Age } from "../ads-params/age.entity";
import { ICoolSystemType } from "../ads-params/cool-system-type.entity";
import { BuildingDocType, IBuildingDocType } from "../ads-params/doc.entity";
import { FlooringMaterialType, IFlooringMaterialType } from "../ads-params/flooring-material-type.entity";
import { IHeatingSystemType } from "../ads-params/heat-system-type.entity";
import { IHeatWaterSystem } from "../ads-params/heat-water-system.entity";
import { Room } from "../ads-params/room.entity";
import { IVillaTotalFloorType, VillaTotalFloorType } from "../ads-params/villa-total-floor-type.entity";
import { IWallMaterialType, WallMaterialType } from "../ads-params/wall-material-type.entity";
import { Advertise, IAdvertise } from "../advertise.entity";
export declare class SaleStore extends Advertise implements ISaleStore {
    constructor(props?: ISaleStore);
    afterLoad(): void;
    updateProps(): void;
    totalPrice?: number;
    meterage?: number;
    landMeterage?: number;
    landLength?: number;
    landWidth?: number;
    buildingType?: 'farming' | 'niches' | 'workhouse';
    docType?: BuildingDocType;
    isWorkhosue?: boolean;
    age?: Age;
    room?: Room;
    storeTotalFloors?: VillaTotalFloorType;
    hasStoreHouse?: boolean;
    hasRoofCrane?: boolean;
    flooringMaterialType?: FlooringMaterialType;
    wallMaterialType?: WallMaterialType;
    coolingSystemType?: ICoolSystemType;
    heatingSystemType?: IHeatingSystemType;
    heatWaterSystemType?: IHeatWaterSystem;
    hasLift?: boolean;
    hasShelf?: boolean;
    hasAlarm?: boolean;
    hasCCTV?: boolean;
    hasElectricShutters?: boolean;
    hasFireExtinguishing?: boolean;
    hasSecurityRoom?: boolean;
    hasAdministrativeRoom?: boolean;
    hasInternetMast?: boolean;
    hasDinningSalon?: boolean;
    hasWeighbridge?: boolean;
    hasWaterWell?: boolean;
}
export interface ISaleStore extends IAdvertise {
    totalPrice?: number;
    meterage?: number;
    landMeterage?: number;
    landLength?: number;
    landWidth?: number;
    buildingType?: 'farming' | 'niches' | 'workhouse';
    docType?: IBuildingDocType;
    isWorkhosue?: boolean;
    age?: Age;
    room?: Room;
    storeTotalFloors?: IVillaTotalFloorType;
    hasStoreHouse?: boolean;
    hasRoofCrane?: boolean;
    flooringMaterialType?: IFlooringMaterialType;
    wallMaterialType?: IWallMaterialType;
    coolingSystemType?: ICoolSystemType;
    heatingSystemType?: IHeatingSystemType;
    heatWaterSystemType?: IHeatWaterSystem;
    hasLift?: boolean;
    hasShelf?: boolean;
    hasAlarm?: boolean;
    hasCCTV?: boolean;
    hasElectricShutters?: boolean;
    hasFireExtinguishing?: boolean;
    hasSecurityRoom?: boolean;
    hasAdministrativeRoom?: boolean;
    hasInternetMast?: boolean;
    hasDinningSalon?: boolean;
    hasWeighbridge?: boolean;
    hasWaterWell?: boolean;
}
