import { Age, IAge } from '../ads-params/age.entity';
import { BuildingSide, IBuildingSide } from '../ads-params/builing-side.entity';
import { CabinetType, ICabinetType } from '../ads-params/cabinet.entity';
import { CoolingSystemType, ICoolSystemType } from '../ads-params/cool-system-type.entity';
import { BuildingDocType, IBuildingDocType } from '../ads-params/doc.entity';
import { FlooringMaterialType, IFlooringMaterialType } from '../ads-params/flooring-material-type.entity';
import { HeatingSystemType, IHeatingSystemType } from '../ads-params/heat-system-type.entity';
import { HeatWaterSystemType, IHeatWaterSystem } from '../ads-params/heat-water-system.entity';
import { IRoom, Room } from '../ads-params/room.entity';
import { IWC, Wc } from '../ads-params/wc.entity';
import { Advertise, IAdvertise } from '../advertise.entity';
import { IReconstructionType, ReconstructionType } from '../ads-params/construction.entity';
import { IVillaTotalFloorType, VillaTotalFloorType } from '../ads-params/villa-total-floor-type.entity';
export declare class SaleVilla extends Advertise implements ISaleVilla {
    constructor(props?: ISaleVilla);
    afterLoad(): void;
    updateProps(): void;
    totalPrice?: number;
    buildingType?: 'villa-garden' | 'garden' | 'villa';
    landMeterage?: number;
    buildingMeterage?: number;
    saleAsInstallment?: boolean;
    prepaymentPercent?: number;
    prepayment?: number;
    installmentAmount?: number;
    installmentNumber?: number;
    installmentPledge?: 'zamen' | 'safteh' | 'check';
    hasLoan?: boolean;
    totalLoanAmount?: number;
    loanInstallmentAmount?: number;
    loanInstallmentNumber?: number;
    age?: Age;
    room: Room;
    hasGarage?: boolean;
    hasStoreHouse?: boolean;
    docType: BuildingDocType;
    villaTotalFloors: VillaTotalFloorType;
    buildingSide?: BuildingSide;
    reconstruct?: ReconstructionType;
    flooringMaterialType?: FlooringMaterialType;
    cabinetType?: CabinetType;
    wc?: Wc;
    coolingSystemType?: CoolingSystemType;
    heatingSystemType?: HeatingSystemType;
    heatWaterSystemType?: HeatWaterSystemType;
    hasCentralAnthena?: boolean;
    hasConferenceHall?: boolean;
    hasBathTub?: boolean;
    hasMasterRoom?: boolean;
    hasBalcony?: boolean;
    hasGazebo?: boolean;
    hasSwimmingPool?: boolean;
    hasRoofGarden?: boolean;
    hasLobby?: boolean;
    hasGamingRoom?: boolean;
    hasSportingHall?: boolean;
    hasSaunaJacuzzi?: boolean;
}
export interface ISaleVilla extends IAdvertise {
    totalPrice?: number;
    landMeterage?: number;
    buildingMeterage?: number;
    buildingType?: 'villa-garden' | 'garden' | 'villa';
    saleAsInstallment?: boolean;
    prepaymentPercent?: number;
    prepayment?: number;
    installmentAmount?: number;
    installmentNumber?: number;
    installmentPledge?: 'zamen' | 'safteh' | 'check';
    hasLoan?: boolean;
    totalLoanAmount?: number;
    loanInstallmentAmount?: number;
    loanInstallmentNUmber?: number;
    age?: IAge;
    room?: IRoom;
    villaTotalFloors?: IVillaTotalFloorType;
    hasGarage?: boolean;
    hasStoreHouse?: boolean;
    docType?: IBuildingDocType;
    buildingSide?: IBuildingSide;
    reconstruct?: IReconstructionType;
    flooringMaterialType?: IFlooringMaterialType;
    cabinetType?: ICabinetType;
    wc?: IWC;
    coolingSystemType?: ICoolSystemType;
    heatingSystemType?: IHeatingSystemType;
    heatWaterSystemType?: IHeatWaterSystem;
    hasCentralAnthena?: boolean;
    hasConferenceHall?: boolean;
    hasBathTub?: boolean;
    hasMasterRoom?: boolean;
    hasBalcony?: boolean;
    hasGazebo?: boolean;
    hasSwimmingPool?: boolean;
    hasRoofGarden?: boolean;
    hasLobby?: boolean;
    hasGamingRoom?: boolean;
    hasSportingHall?: boolean;
    hasSaunaJacuzzi?: boolean;
}
