import { IPlaceEntity, PlaceEntity } from './place.entity';
import { SharedEntity } from './shared.entity';
import { IUserEntity, UserEntity } from './user.entity';
export declare class Advertise extends SharedEntity<IAdvertise> implements IAdvertise {
    constructor(props?: IAdvertise);
    category?: 'residence-sale' | 'residence-rent' | 'commercial-sale' | 'commercial-rent' | 'short-term-rent' | 'construction';
    propertyType?: string;
    city?: PlaceEntity;
    district?: PlaceEntity;
    location?: any;
    thumbnail?: string;
    images?: string[];
    subject?: string;
    title?: string;
    description?: string;
    showContactInfo?: boolean;
    canChat?: boolean;
    sendToAgencyAndConsultUser?: boolean;
    advertizer: UserEntity;
}
export interface IAdvertise {
    category?: 'residence-sale' | 'residence-rent' | 'commercial-sale' | 'commercial-rent' | 'short-term-rent' | 'construction';
    city?: IPlaceEntity;
    district?: IPlaceEntity;
    location?: any;
    thumbnail?: string | null;
    images?: string[];
    subject?: string;
    title?: string;
    description?: string;
    advertizer?: IUserEntity;
    showContactInfo?: boolean;
    canChat?: boolean;
    sendToAgencyAndConsultUser?: boolean;
}
