"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./query");
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const swagger_1 = require("@nestjs/swagger");
const db_1 = require("./db");
const common_1 = require("@nestjs/common");
const response_interceptor_1 = require("./core/interceptor/response.interceptor");
const http_exection_filter_1 = require("./core/filters/http-exection.filter");
const other_exception_filter_1 = require("./core/filters/other.exception.filter");
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule);
    app.enableCors({
        origin: '*',
        methods: 'GET,HEAD,PUT,PATCH,POST,DELETE',
        preflightContinue: false,
        optionsSuccessStatus: 204,
    });
    await db_1.DbInstance.connect();
    app.useGlobalInterceptors(new response_interceptor_1.ResponseInterceptor());
    app.useGlobalPipes(new common_1.ValidationPipe({
        whitelist: false,
    }));
    app.useGlobalFilters(new other_exception_filter_1.OtherExceptionFilter());
    app.useGlobalFilters(new http_exection_filter_1.HttpExceptionFilter());
    app.setGlobalPrefix('api/v1');
    const config = new swagger_1.DocumentBuilder()
        .setTitle('Khanehaval api')
        .setDescription('')
        .setVersion('1.0')
        .addBearerAuth({
        type: 'http',
        scheme: 'bearer',
        bearerFormat: 'JWT',
    }, 'access-token')
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    swagger_1.SwaggerModule.setup('docs', app, document);
    await app.listen(5000);
}
bootstrap();
//# sourceMappingURL=main.js.map