"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdversInterceptor = void 0;
const rxjs_1 = require("rxjs");
class AdversInterceptor {
    intercept(context, next) {
        return next
            .handle()
            .pipe((0, rxjs_1.map)((x) => this._modify(x)));
    }
    _modify(x) {
        const { city, district, createdAt, updatedAt, images, ...rest } = x || {};
        const keys = ["age", "room", "docType", "totalFloors", "buildingSide", "reconstruct", "flooringMaterialType", "unitInFloor",
            "cabinetType",
            "wc",
            "coolingSystemType",
            "heatingSystemType",
            "heatWaterSystemType",
            "villaTotalFloors"
        ];
        let response = {
            ...rest,
            cityId: city?.id,
            districtId: district?.id,
            images: images ? images : []
        };
        keys.map(k => {
            console.log('key: ', k);
            if (response[k] && response[k] !== null) {
                console.log('value: ', response[k]);
                response[k] = response[k].id;
            }
        });
        for (let item in keys) {
        }
        return response;
    }
}
exports.AdversInterceptor = AdversInterceptor;
//# sourceMappingURL=advers.interceptor.js.map