"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdversPipe = void 0;
const common_1 = require("@nestjs/common");
const age_entity_1 = require("../../db/entities/ads-params/age.entity");
const builing_side_entity_1 = require("../../db/entities/ads-params/builing-side.entity");
const cabinet_entity_1 = require("../../db/entities/ads-params/cabinet.entity");
const construction_entity_1 = require("../../db/entities/ads-params/construction.entity");
const cool_system_type_entity_1 = require("../../db/entities/ads-params/cool-system-type.entity");
const doc_entity_1 = require("../../db/entities/ads-params/doc.entity");
const floor_number_entity_1 = require("../../db/entities/ads-params/floor-number.entity");
const flooring_material_type_entity_1 = require("../../db/entities/ads-params/flooring-material-type.entity");
const heat_system_type_entity_1 = require("../../db/entities/ads-params/heat-system-type.entity");
const heat_water_system_entity_1 = require("../../db/entities/ads-params/heat-water-system.entity");
const room_entity_1 = require("../../db/entities/ads-params/room.entity");
const total_floor_type_entity_1 = require("../../db/entities/ads-params/total-floor-type.entity");
const unit_in_each_floor_enity_1 = require("../../db/entities/ads-params/unit-in-each-floor.enity");
const villa_total_floor_type_entity_1 = require("../../db/entities/ads-params/villa-total-floor-type.entity");
const wc_entity_1 = require("../../db/entities/ads-params/wc.entity");
const place_entity_1 = require("../../db/entities/place.entity");
const repositories_1 = require("../../db/repositories");
let AdversPipe = class AdversPipe {
    async transform(value) {
        const _places = repositories_1.db.getRepository(place_entity_1.PlaceEntity);
        const _ages = repositories_1.db.getRepository(age_entity_1.Age);
        const _sides = repositories_1.db.getRepository(builing_side_entity_1.BuildingSide);
        const _coolings = repositories_1.db.getRepository(cool_system_type_entity_1.CoolingSystemType);
        const _docTypes = repositories_1.db.getRepository(doc_entity_1.BuildingDocType);
        const _floorNumbers = repositories_1.db.getRepository(floor_number_entity_1.FloorNubmer);
        const _totalfloorTypes = repositories_1.db.getRepository(total_floor_type_entity_1.TotalFloorType);
        const _floorings = repositories_1.db.getRepository(flooring_material_type_entity_1.FlooringMaterialType);
        const _heatings = repositories_1.db.getRepository(heat_system_type_entity_1.HeatingSystemType);
        const _heatWater = repositories_1.db.getRepository(heat_water_system_entity_1.HeatWaterSystemType);
        const _rooms = repositories_1.db.getRepository(room_entity_1.Room);
        const _unitInFloors = repositories_1.db.getRepository(unit_in_each_floor_enity_1.UnitInEachFloor);
        const _wcs = repositories_1.db.getRepository(wc_entity_1.Wc);
        const _cabinets = repositories_1.db.getRepository(cabinet_entity_1.CabinetType);
        const _reconstructTypes = repositories_1.db.getRepository(construction_entity_1.ReconstructionType);
        const _villaTotalFloorsType = repositories_1.db.getRepository(villa_total_floor_type_entity_1.VillaTotalFloorType);
        let { cityId, districtId, age, room, floorNumber, docType, totalFloors, unitInFloor, buildingSide, flooringMaterialType, cabinetType, wc, coolingSystemType, heatingSystemType, heatWaterSystemType, reconstruct, villaTotalFloors, ...rest } = value || {};
        const city = await _places.findOneBy({ id: cityId });
        const district = await _places.findOneBy({ id: districtId });
        if (age) {
            age = await _ages.findOneBy({ id: age });
            rest = { ...rest, age };
        }
        if (reconstruct) {
            reconstruct = await _reconstructTypes.findOneBy({ id: reconstruct });
            rest = { ...rest, reconstruct };
        }
        if (villaTotalFloors) {
            villaTotalFloors = await _villaTotalFloorsType.findOneBy({ id: villaTotalFloors });
            rest = { ...rest, villaTotalFloors };
        }
        if (room) {
            room = await _rooms.findOneBy({ id: room });
            rest = { ...rest, room };
        }
        if (floorNumber) {
            floorNumber = await _floorNumbers.findOneBy({ id: floorNumber });
            rest = { ...rest, floorNumber };
        }
        if (totalFloors) {
            totalFloors = await _totalfloorTypes.findOneBy({ id: totalFloors });
            rest = { ...rest, totalFloors };
        }
        if (docType) {
            docType = await _docTypes.findOneBy({ id: docType });
            rest = { ...rest, docType };
        }
        if (unitInFloor) {
            unitInFloor = await _unitInFloors.findOneBy({ id: unitInFloor });
            rest = { ...rest, unitInFloor };
        }
        if (buildingSide) {
            buildingSide = await _sides.findOneBy({ id: buildingSide });
            rest = { ...rest, buildingSide };
        }
        if (flooringMaterialType) {
            flooringMaterialType = await _floorings.findOneBy({
                id: flooringMaterialType,
            });
            rest = { ...rest, flooringMaterialType };
        }
        if (cabinetType) {
            cabinetType = await _cabinets.findOneBy({ id: cabinetType });
            rest = { ...rest, cabinetType };
        }
        if (wc) {
            wc = await _wcs.findOneBy({ id: wc });
            rest = { ...rest, wc };
        }
        if (coolingSystemType) {
            coolingSystemType = await _coolings.findOneBy({ id: coolingSystemType });
            rest = { ...rest, coolingSystemType };
        }
        if (heatingSystemType) {
            heatWaterSystemType = await _heatings.findOneBy({
                id: heatingSystemType,
            });
            rest = { ...rest, heatingSystemType };
        }
        if (heatWaterSystemType) {
            heatWaterSystemType = await _heatWater.findOneBy({
                id: heatWaterSystemType,
            });
            rest = { ...rest, heatWaterSystemType };
        }
        return {
            ...rest,
            city,
            district,
            propertyType: 'apartment-sale',
            category: 'residence-sale',
        };
    }
};
exports.AdversPipe = AdversPipe;
exports.AdversPipe = AdversPipe = __decorate([
    (0, common_1.Injectable)()
], AdversPipe);
//# sourceMappingURL=advers.pipe.js.map