"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetAdvertiseListHandler = exports.GetAdvertiseList = void 0;
const cqrs_1 = require("@nestjs/cqrs");
const advertise_entity_1 = require("../../../../db/entities/advertise.entity");
const repositories_1 = require("../../../../db/repositories");
const query_1 = require("../../../../model/query");
const _advertsies = repositories_1.db.getRepository(advertise_entity_1.Advertise);
class GetAdvertiseListQueryModel extends query_1.QueryModel {
}
class GetAdvertiseList {
    constructor(query) {
        this.query = query;
    }
}
exports.GetAdvertiseList = GetAdvertiseList;
let GetAdvertiseListHandler = class GetAdvertiseListHandler {
    async execute({ query }) {
        const list = await _advertsies
            .createQueryBuilder('ads')
            .leftJoinAndSelect('ads.advertizer', 'advertizer')
            .leftJoinAndSelect('ads.city', 'city')
            .leftJoinAndSelect('ads.district', 'district')
            .select(['ads', 'advertizer', 'city', 'district'])
            .addSelect(['ads.propertyType', 'ads.category'])
            .getMany();
        return list;
    }
};
exports.GetAdvertiseListHandler = GetAdvertiseListHandler;
exports.GetAdvertiseListHandler = GetAdvertiseListHandler = __decorate([
    (0, cqrs_1.QueryHandler)(GetAdvertiseList)
], GetAdvertiseListHandler);
//# sourceMappingURL=GetAdvertiseList.js.map