"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminLoginCommandHandler = exports.AdminLoginCommand = void 0;
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const handled_error_1 = require("../../../../core/classes/handled-error");
const jwt_1 = require("@nestjs/jwt");
const password_1 = require("../../../../config/password");
const dict_1 = require("../../../../constants/dict");
const users = repositories_1.default.users;
class AdminLoginCommand {
    constructor(dto) {
        this.dto = dto;
    }
}
exports.AdminLoginCommand = AdminLoginCommand;
let AdminLoginCommandHandler = class AdminLoginCommandHandler {
    constructor(jwt) {
        this.jwt = jwt;
    }
    async execute(command) {
        const { userName, password } = command.dto;
        const user = await users
            .createQueryBuilder('user')
            .where('user.cellphone = :userName', { userName })
            .addSelect("user.password")
            .getOne();
        if (!user)
            throw new handled_error_1.HandledError(dict_1.default.WRONG_USERNAME_OR_PASSWORD);
        if (user.isSystemUser)
            throw new handled_error_1.HandledError(dict_1.default.USER_IS_NOT_ALLOWED);
        const correct = await (0, password_1.verify)(user.password, password);
        if (!correct)
            throw new handled_error_1.HandledError(dict_1.default.WRONG_USERNAME_OR_PASSWORD);
        const payload = {
            id: user.id,
        };
        return {
            token: this.jwt.sign(payload),
            user,
        };
    }
};
exports.AdminLoginCommandHandler = AdminLoginCommandHandler;
exports.AdminLoginCommandHandler = AdminLoginCommandHandler = __decorate([
    (0, cqrs_1.CommandHandler)(AdminLoginCommand),
    __metadata("design:paramtypes", [jwt_1.JwtService])
], AdminLoginCommandHandler);
//# sourceMappingURL=AdminLoginCommand.js.map