"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoginHandler = exports.LoginCommand = void 0;
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const sms_service_1 = require("../../sms.service");
const user_entity_1 = require("../../../../db/entities/user.entity");
const message_entity_1 = require("../../../../db/entities/user/message.entity");
const { users, messages } = repositories_1.default;
class LoginCommand {
    constructor(props) {
        this.props = props;
    }
}
exports.LoginCommand = LoginCommand;
let LoginHandler = class LoginHandler {
    constructor(sms) {
        this.sms = sms;
    }
    async execute(command) {
        const { cellphone } = command.props;
        const code = `${Math.floor(Math.random() * 99999)}`;
        const message = new message_entity_1.MessageEntity({ code });
        let user = await users.findOneBy({ cellphone });
        if (!user) {
            user = new user_entity_1.UserEntity({ cellphone, isSystemUser: false });
            await user.save();
        }
        message.user = user;
        await message.save();
        this.sms.send(cellphone, code);
        return 'done';
    }
};
exports.LoginHandler = LoginHandler;
exports.LoginHandler = LoginHandler = __decorate([
    (0, cqrs_1.CommandHandler)(LoginCommand),
    __metadata("design:paramtypes", [sms_service_1.SMSService])
], LoginHandler);
//# sourceMappingURL=LoginCommand.js.map