"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericControllerMixin = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const crud_service_1 = require("./crud.service");
function GenericControllerMixin(entityClass, path) {
    const tagName = entityClass.name;
    class ListResponse {
    }
    __decorate([
        (0, swagger_1.ApiProperty)(),
        __metadata("design:type", Boolean)
    ], ListResponse.prototype, "status", void 0);
    __decorate([
        (0, swagger_1.ApiProperty)({ type: [entityClass] }),
        __metadata("design:type", Array)
    ], ListResponse.prototype, "data", void 0);
    let GenericController = class GenericController {
        constructor(srv) {
            this.srv = srv;
        }
        async list() {
            return await this.srv.list(tagName);
        }
        async signle(id) {
            return await this.srv.single(tagName, id);
        }
        async upsert(dto) {
            return await this.srv.upsert(tagName, dto);
        }
        async remove(id) {
            return await this.srv.remove(tagName, id);
        }
    };
    __decorate([
        (0, common_1.Get)(),
        (0, swagger_1.ApiOkResponse)({ type: ListResponse }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], GenericController.prototype, "list", null);
    __decorate([
        (0, common_1.Get)(':id'),
        __param(0, (0, common_1.Param)('id')),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
    ], GenericController.prototype, "signle", null);
    __decorate([
        (0, common_1.Post)(),
        (0, swagger_1.ApiBody)({ type: entityClass }),
        __param(0, (0, common_1.Body)()),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Promise)
    ], GenericController.prototype, "upsert", null);
    __decorate([
        (0, common_1.Delete)(':id'),
        __param(0, (0, common_1.Param)('id')),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String]),
        __metadata("design:returntype", Promise)
    ], GenericController.prototype, "remove", null);
    GenericController = __decorate([
        (0, swagger_1.ApiTags)(tagName.split(/\.?(?=[A-Z])/).join(' ')),
        __metadata("design:paramtypes", [crud_service_1.CurdService])
    ], GenericController);
    (0, common_1.Controller)(`base/${path}`)(GenericController);
    return GenericController;
}
exports.GenericControllerMixin = GenericControllerMixin;
//# sourceMappingURL=crud.controller.js.map