"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurdService = void 0;
const common_1 = require("@nestjs/common");
const repositories_1 = require("../../../db/repositories");
const handled_error_1 = require("../../../core/classes/handled-error");
const dict_1 = require("../../../constants/dict");
let CurdService = class CurdService {
    async list(entityName) {
        const repo = repositories_1.db.getRepository(entityName);
        const list = await repo.find();
        return list;
    }
    async upsert(entityName, entity) {
        const { id, ...rest } = entity || {};
        const repo = await repositories_1.db.getRepository(entityName);
        if (id) {
            let item = await repo.findOneBy({ id });
            if (!item)
                throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
            item.update(rest);
            await item.save();
            return item;
        }
        else {
            const item = await repo.save(rest);
            return item;
        }
    }
    async single(entityName, id) {
        const repo = await repositories_1.db.getRepository(entityName);
        const item = await repo.findOneBy({ id });
        if (!item)
            throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
        return item;
    }
    async remove(entityName, id) {
        const repo = await repositories_1.db.getRepository(entityName);
        const item = await repo.findOneBy({ id });
        if (!item)
            throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
        await item.softRemove();
        return dict_1.default.SUCCESS_MESSAGE;
    }
};
exports.CurdService = CurdService;
exports.CurdService = CurdService = __decorate([
    (0, common_1.Injectable)()
], CurdService);
//# sourceMappingURL=crud.service.js.map