"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminPlaceController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const cqrs_1 = require("@nestjs/cqrs");
const handlers_1 = require("./handlers");
const GetSinglePlace_1 = require("./handlers/queries/GetSinglePlace");
let AdminPlaceController = class AdminPlaceController {
    constructor(command, queryBus) {
        this.command = command;
        this.queryBus = queryBus;
    }
    list(query) {
        return this.queryBus.execute(new handlers_1.GetPlacesListQuery(query));
    }
    upsert(data) {
        return this.command.execute(new handlers_1.UpsertPlaceCommand(data));
    }
    single(id) {
        return this.queryBus.execute(new GetSinglePlace_1.GetSinglePlaceQuery(id));
    }
    remove(id) {
        return this.command.execute(new handlers_1.DeletePlaceCommand(id));
    }
};
exports.AdminPlaceController = AdminPlaceController;
__decorate([
    (0, common_1.Get)(''),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [handlers_1.GetPlacesListRequest]),
    __metadata("design:returntype", void 0)
], AdminPlaceController.prototype, "list", null);
__decorate([
    (0, common_1.Post)(''),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [handlers_1.UpsertPlaceRequest]),
    __metadata("design:returntype", void 0)
], AdminPlaceController.prototype, "upsert", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, swagger_1.ApiOkResponse)({
        type: GetSinglePlace_1.GetSinglePlaceResponse,
    }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AdminPlaceController.prototype, "single", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], AdminPlaceController.prototype, "remove", null);
exports.AdminPlaceController = AdminPlaceController = __decorate([
    (0, swagger_1.ApiTags)('Places Admin'),
    (0, common_1.Controller)('admin/place'),
    __metadata("design:paramtypes", [cqrs_1.CommandBus,
        cqrs_1.QueryBus])
], AdminPlaceController);
//# sourceMappingURL=admin-place.controller.js.map