"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpsertPlaceRequest = exports.UpsertPlaceHandler = exports.UpsertPlaceCommand = void 0;
const swagger_1 = require("@nestjs/swagger");
const place_entity_1 = require("../../../../db/entities/place.entity");
const place_info_entity_1 = require("../../../../db/entities/place-info.entity");
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const handled_error_1 = require("../../../../core/classes/handled-error");
const dict_1 = require("../../../../constants/dict");
const class_validator_1 = require("class-validator");
const typeorm_1 = require("typeorm");
const _places = repositories_1.db.getRepository(place_entity_1.PlaceEntity);
const _placesInfo = repositories_1.db.getRepository(place_info_entity_1.PlaceInfoEntity);
class UpsertPlaceCommand {
    constructor(data) {
        this.data = data;
    }
}
exports.UpsertPlaceCommand = UpsertPlaceCommand;
let UpsertPlaceHandler = class UpsertPlaceHandler {
    async execute({ data }) {
        const { id, name, eName, type, parent: _parentId, ...rest } = data || {};
        if (id) {
            let place = await _places.findOneBy({ eName, id: (0, typeorm_1.Not)(`${id}`) });
            if (place)
                throw new handled_error_1.HandledError(dict_1.default.ENAME_IS_USED);
            place = await _places.findOne({
                where: { id },
                relations: {
                    info: true,
                },
            });
            if (!place)
                throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
            place.update({ name, eName, type });
            if (_parentId) {
                let parent = await _places.findOneBy({ id: _parentId });
                if (!parent)
                    throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
                place.parent = parent;
            }
            else {
                place.parent = null;
            }
            await place.save();
            const info = await _placesInfo.findOneBy({ id: place.info.id });
            info.update({ ...rest });
            await info.save();
            return dict_1.default.SUCCESS_MESSAGE;
        }
        else {
            let place = await _places.findOneBy({ eName });
            if (place)
                throw new handled_error_1.HandledError(dict_1.default.ENAME_IS_USED);
            const placeInfo = new place_info_entity_1.PlaceInfoEntity({
                ...rest,
            });
            await placeInfo.save();
            place = new place_entity_1.PlaceEntity({
                name,
                eName,
                type,
                info: placeInfo,
            });
            if (_parentId) {
                let parent = await _places.findOneBy({ id: _parentId });
                if (!parent)
                    throw new handled_error_1.HandledError(dict_1.default.RECORDE_DOES_NOT_EkXIST);
                place.parent = parent;
            }
            await place.save();
            return dict_1.default.SUCCESS_MESSAGE;
        }
    }
};
exports.UpsertPlaceHandler = UpsertPlaceHandler;
exports.UpsertPlaceHandler = UpsertPlaceHandler = __decorate([
    (0, cqrs_1.CommandHandler)(UpsertPlaceCommand)
], UpsertPlaceHandler);
class UpsertPlaceRequest {
}
exports.UpsertPlaceRequest = UpsertPlaceRequest;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPlaceRequest.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPlaceRequest.prototype, "parent", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: dict_1.default.BAD_REQUEST }),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPlaceRequest.prototype, "name", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: dict_1.default.BAD_REQUEST }),
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPlaceRequest.prototype, "eName", void 0);
__decorate([
    (0, class_validator_1.IsNotEmpty)({ message: dict_1.default.BAD_REQUEST }),
    (0, swagger_1.ApiProperty)({ enum: ['country', 'province'] }),
    __metadata("design:type", String)
], UpsertPlaceRequest.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: Boolean }),
    __metadata("design:type", Boolean)
], UpsertPlaceRequest.prototype, "canInsertAdvertise", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: Boolean }),
    __metadata("design:type", Boolean)
], UpsertPlaceRequest.prototype, "canInsertCommercial", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: Boolean }),
    __metadata("design:type", Boolean)
], UpsertPlaceRequest.prototype, "canInsertSpecialAdvertise", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [String] }),
    __metadata("design:type", Array)
], UpsertPlaceRequest.prototype, "closeCities", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: Boolean }),
    __metadata("design:type", Boolean)
], UpsertPlaceRequest.prototype, "isCapitalCounty", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPlaceRequest.prototype, "location", void 0);
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UpsertPlaceRequest.prototype, "polygon", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: Boolean }),
    __metadata("design:type", Boolean)
], UpsertPlaceRequest.prototype, "showAdvertise", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: Boolean }),
    __metadata("design:type", Boolean)
], UpsertPlaceRequest.prototype, "showCommercial", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: Boolean }),
    __metadata("design:type", Boolean)
], UpsertPlaceRequest.prototype, "showSpecialAdvertise", void 0);
//# sourceMappingURL=UpsertPlace.js.map