"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetPlacesListRequest = exports.GetPlacesListHandler = exports.GetPlacesListQuery = void 0;
const cqrs_1 = require("@nestjs/cqrs");
const repositories_1 = require("../../../../db/repositories");
const place_entity_1 = require("../../../../db/entities/place.entity");
const swagger_1 = require("@nestjs/swagger");
const query_1 = require("../../../../model/query");
const places = repositories_1.db.getRepository(place_entity_1.PlaceEntity);
class GetPlacesListQuery {
    constructor(dto) {
        this.dto = dto;
    }
}
exports.GetPlacesListQuery = GetPlacesListQuery;
let GetPlacesListHandler = class GetPlacesListHandler {
    async execute({ dto }) {
        const { offset, size, parent, type } = dto || {};
        let query = places
            .createQueryBuilder('place')
            .leftJoinAndSelect('place.parent', 'parent')
            .select(['place', 'parent']);
        if (type) {
            query = query.andWhere('place.type = :type', { type });
        }
        if (parent) {
            query = query.andWhere('parent.id= :parent', { parent });
        }
        if (size) {
            query = query.paginate({ offset, size });
        }
        let [list, total] = await Promise.all([query.getMany(), query.getCount()]);
        return {
            list,
            total,
        };
    }
};
exports.GetPlacesListHandler = GetPlacesListHandler;
exports.GetPlacesListHandler = GetPlacesListHandler = __decorate([
    (0, cqrs_1.QueryHandler)(GetPlacesListQuery)
], GetPlacesListHandler);
class GetPlacesListRequest extends query_1.QueryModel {
}
exports.GetPlacesListRequest = GetPlacesListRequest;
__decorate([
    (0, swagger_1.ApiProperty)({
        enum: ['country', 'province', 'city', 'country', 'area', 'union'],
        required: false,
    }),
    __metadata("design:type", String)
], GetPlacesListRequest.prototype, "type", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        required: false,
    }),
    __metadata("design:type", String)
], GetPlacesListRequest.prototype, "parent", void 0);
//# sourceMappingURL=GetPlacesList.js.map