"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminUserController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const cqrs_1 = require("@nestjs/cqrs");
const GetUserListQuery_1 = require("./handlers/queries/GetUserListQuery");
const GetUserListResponse_1 = require("./models/GetUserListResponse");
const handlers_1 = require("./handlers");
let AdminUserController = class AdminUserController {
    constructor(command, query) {
        this.command = command;
        this.query = query;
    }
    async users(query) {
        return this.query.execute(new GetUserListQuery_1.GetUserListQuery(query));
    }
    async user() { }
    async upsert(data) {
        return await this.command.execute(new handlers_1.UpsertSystemUserCommand(data));
    }
    async changePassword() { }
    async delete() { }
};
exports.AdminUserController = AdminUserController;
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOkResponse)({
        type: GetUserListResponse_1.GetUserListResponse,
    }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [GetUserListQuery_1.GetUserListDto]),
    __metadata("design:returntype", Promise)
], AdminUserController.prototype, "users", null);
__decorate([
    (0, common_1.Get)(':id'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AdminUserController.prototype, "user", null);
__decorate([
    (0, common_1.Post)('system'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [handlers_1.UpsertSystemUserRequestModel]),
    __metadata("design:returntype", Promise)
], AdminUserController.prototype, "upsert", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AdminUserController.prototype, "changePassword", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AdminUserController.prototype, "delete", null);
exports.AdminUserController = AdminUserController = __decorate([
    (0, swagger_1.ApiTags)('User Admin'),
    (0, common_1.Controller)('admin/user'),
    __metadata("design:paramtypes", [cqrs_1.CommandBus,
        cqrs_1.QueryBus])
], AdminUserController);
//# sourceMappingURL=admin-user.controller.js.map