import { ICommandHandler } from '@nestjs/cqrs';
import { LocationAddressModel } from '~model/address';
import { UserEntity } from '~db/entities/user.entity';
export declare class UpsertConsultantUserCommand {
    dto: UpsertConsultantUserRequestModel;
    user: UserEntity;
    constructor(dto: UpsertConsultantUserRequestModel, user: UserEntity);
}
export declare class UpsertConsultantHandler implements ICommandHandler<UpsertConsultantUserCommand> {
    execute({ dto, user: current, }: UpsertConsultantUserCommand): Promise<any>;
}
export declare class UpsertConsultantUserRequestModel {
    firstName: string;
    lastName: string;
    userName: string;
    licenseImg: string;
    address: LocationAddressModel;
    nationalCode: string;
    cityId: string;
    areasId: string[];
}
